/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.utils.ByteStructVertexIdDataIterator;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.giraph.utils.VertexIdData;
import org.apache.hadoop.io.WritableComparable;

public abstract class AbstractVertexIdData<I extends WritableComparable, T>
implements VertexIdData<I, T> {
    protected ExtendedDataOutput extendedDataOutput;
    private ImmutableClassesGiraphConfiguration<I, ?, ?> configuration;

    @Override
    public void initialize() {
        this.extendedDataOutput = this.getConf().createExtendedDataOutput();
    }

    @Override
    public void initialize(int expectedSize) {
        this.extendedDataOutput = this.getConf().createExtendedDataOutput(expectedSize);
    }

    @Override
    public void add(I vertexId, T data) {
        try {
            vertexId.write((DataOutput)this.extendedDataOutput);
            this.writeData(this.extendedDataOutput, data);
        }
        catch (IOException e) {
            throw new IllegalStateException("add: IOException", e);
        }
    }

    @Override
    public void add(byte[] serializedId, int idPos, T data) {
        try {
            this.extendedDataOutput.write(serializedId, 0, idPos);
            this.writeData(this.extendedDataOutput, data);
        }
        catch (IOException e) {
            throw new IllegalStateException("add: IOException", e);
        }
    }

    @Override
    public int getSize() {
        return this.extendedDataOutput.getPos();
    }

    @Override
    public int getSerializedSize() {
        return 5 + this.getSize();
    }

    @Override
    public boolean isEmpty() {
        return this.extendedDataOutput.getPos() == 0;
    }

    @Override
    public void clear() {
        this.extendedDataOutput.reset();
    }

    @Override
    public void setConf(ImmutableClassesGiraphConfiguration configuration) {
        this.configuration = configuration;
    }

    public ImmutableClassesGiraphConfiguration<I, ?, ?> getConf() {
        return this.configuration;
    }

    @Override
    public ByteStructVertexIdDataIterator<I, T> getVertexIdDataIterator() {
        return new ByteStructVertexIdDataIterator(this);
    }

    public void write(DataOutput output) throws IOException {
        throw new UnsupportedOperationException("not supported");
    }

    public void readFields(DataInput dataInput) throws IOException {
        throw new UnsupportedOperationException("not supported");
    }
}

