/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.types.ops.collections;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.types.ops.IntTypeOps;
import org.apache.giraph.types.ops.LongTypeOps;
import org.apache.giraph.types.ops.PrimitiveIdTypeOps;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

public interface BasicSet<T>
extends Writable {
    public void clear();

    public int size();

    public void trim(int var1);

    public boolean add(T var1);

    public boolean contains(T var1);

    public PrimitiveIdTypeOps<T> getElementTypeOps();

    public static final class BasicLongOpenHashSet
    implements BasicSet<LongWritable> {
        private final LongOpenHashSet set;

        public BasicLongOpenHashSet(int capacity) {
            this.set = new LongOpenHashSet(capacity);
        }

        @Override
        public void clear() {
            this.set.clear();
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public void trim(int n) {
            this.set.trim(Math.max(this.set.size(), n));
        }

        @Override
        public boolean add(LongWritable value) {
            return this.set.add(value.get());
        }

        @Override
        public boolean contains(LongWritable value) {
            return this.set.contains(value.get());
        }

        @Override
        public PrimitiveIdTypeOps<LongWritable> getElementTypeOps() {
            return LongTypeOps.INSTANCE;
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.set.size());
            LongIterator iter = this.set.iterator();
            while (iter.hasNext()) {
                out.writeLong(iter.nextLong());
            }
        }

        public void readFields(DataInput in) throws IOException {
            int size = in.readInt();
            this.set.clear();
            this.trim(size);
            for (int i = 0; i < size; ++i) {
                this.set.add(in.readLong());
            }
        }
    }

    public static final class BasicIntOpenHashSet
    implements BasicSet<IntWritable> {
        private final IntOpenHashSet set;

        public BasicIntOpenHashSet(int capacity) {
            this.set = new IntOpenHashSet(capacity);
        }

        @Override
        public void clear() {
            this.set.clear();
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public void trim(int n) {
            this.set.trim(Math.max(this.set.size(), n));
        }

        @Override
        public boolean add(IntWritable value) {
            return this.set.add(value.get());
        }

        @Override
        public boolean contains(IntWritable value) {
            return this.set.contains(value.get());
        }

        @Override
        public PrimitiveIdTypeOps<IntWritable> getElementTypeOps() {
            return IntTypeOps.INSTANCE;
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.set.size());
            IntIterator iter = this.set.iterator();
            while (iter.hasNext()) {
                out.writeInt(iter.nextInt());
            }
        }

        public void readFields(DataInput in) throws IOException {
            int size = in.readInt();
            this.set.clear();
            this.set.trim(size);
            for (int i = 0; i < size; ++i) {
                this.set.add(in.readInt());
            }
        }
    }
}

