/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.types.ops.collections;

import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.giraph.types.ops.BooleanTypeOps;
import org.apache.giraph.types.ops.ByteTypeOps;
import org.apache.giraph.types.ops.DoubleTypeOps;
import org.apache.giraph.types.ops.FloatTypeOps;
import org.apache.giraph.types.ops.IntTypeOps;
import org.apache.giraph.types.ops.LongTypeOps;
import org.apache.giraph.types.ops.PrimitiveTypeOps;
import org.apache.giraph.types.ops.collections.ResettableIterator;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

public abstract class BasicArrayList<T>
implements Writable {
    public abstract void clear();

    public abstract int size();

    public abstract int capacity();

    public abstract void setCapacity(int var1);

    public abstract void add(T var1);

    public abstract void popInto(T var1);

    public abstract void getInto(int var1, T var2);

    public abstract void set(int var1, T var2);

    public abstract PrimitiveTypeOps<T> getElementTypeOps();

    public ResettableIterator<T> fastIterator() {
        return new ResettableIterator<T>(){
            private final T value;
            private int pos;
            {
                this.value = BasicArrayList.this.getElementTypeOps().create();
            }

            @Override
            public boolean hasNext() {
                return this.pos < BasicArrayList.this.size();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                BasicArrayList.this.getInto(this.pos, this.value);
                ++this.pos;
                return this.value;
            }

            @Override
            public void reset() {
                this.pos = 0;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static final class BasicDoubleArrayList
    extends BasicArrayList<DoubleWritable> {
        private final DoubleArrayList list;

        public BasicDoubleArrayList(int capacity) {
            this.list = new DoubleArrayList(capacity);
        }

        @Override
        public PrimitiveTypeOps<DoubleWritable> getElementTypeOps() {
            return DoubleTypeOps.INSTANCE;
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public int capacity() {
            return this.list.elements().length;
        }

        @Override
        public void setCapacity(int n) {
            if (n >= this.list.elements().length) {
                this.list.ensureCapacity(n);
            } else {
                this.list.trim(n);
            }
        }

        @Override
        public void add(DoubleWritable value) {
            this.list.add(value.get());
        }

        @Override
        public void getInto(int index, DoubleWritable to) {
            to.set(this.list.getDouble(index));
        }

        @Override
        public void popInto(DoubleWritable to) {
            to.set(this.list.popDouble());
        }

        @Override
        public void set(int index, DoubleWritable value) {
            this.list.set(index, value.get());
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.list.size());
            for (int i = 0; i < this.list.size(); ++i) {
                out.writeDouble(this.list.getDouble(i));
            }
        }

        public void readFields(DataInput in) throws IOException {
            int size = in.readInt();
            this.list.clear();
            this.setCapacity(size);
            for (int i = 0; i < size; ++i) {
                this.list.add(in.readDouble());
            }
        }
    }

    public static final class BasicFloatArrayList
    extends BasicArrayList<FloatWritable> {
        private final FloatArrayList list;

        public BasicFloatArrayList(int capacity) {
            this.list = new FloatArrayList(capacity);
        }

        @Override
        public PrimitiveTypeOps<FloatWritable> getElementTypeOps() {
            return FloatTypeOps.INSTANCE;
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public int capacity() {
            return this.list.elements().length;
        }

        @Override
        public void setCapacity(int n) {
            if (n >= this.list.elements().length) {
                this.list.ensureCapacity(n);
            } else {
                this.list.trim(n);
            }
        }

        @Override
        public void add(FloatWritable value) {
            this.list.add(value.get());
        }

        @Override
        public void getInto(int index, FloatWritable to) {
            to.set(this.list.getFloat(index));
        }

        @Override
        public void popInto(FloatWritable to) {
            to.set(this.list.popFloat());
        }

        @Override
        public void set(int index, FloatWritable value) {
            this.list.set(index, value.get());
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.list.size());
            for (int i = 0; i < this.list.size(); ++i) {
                out.writeFloat(this.list.getFloat(i));
            }
        }

        public void readFields(DataInput in) throws IOException {
            int size = in.readInt();
            this.list.clear();
            this.setCapacity(size);
            for (int i = 0; i < size; ++i) {
                this.list.add(in.readFloat());
            }
        }
    }

    public static final class BasicLongArrayList
    extends BasicArrayList<LongWritable> {
        private final LongArrayList list;

        public BasicLongArrayList(int capacity) {
            this.list = new LongArrayList(capacity);
        }

        @Override
        public PrimitiveTypeOps<LongWritable> getElementTypeOps() {
            return LongTypeOps.INSTANCE;
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public int capacity() {
            return this.list.elements().length;
        }

        @Override
        public void setCapacity(int n) {
            if (n >= this.list.elements().length) {
                this.list.ensureCapacity(n);
            } else {
                this.list.trim(n);
            }
        }

        @Override
        public void add(LongWritable value) {
            this.list.add(value.get());
        }

        @Override
        public void getInto(int index, LongWritable to) {
            to.set(this.list.getLong(index));
        }

        @Override
        public void popInto(LongWritable to) {
            to.set(this.list.popLong());
        }

        @Override
        public void set(int index, LongWritable value) {
            this.list.set(index, value.get());
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.list.size());
            for (int i = 0; i < this.list.size(); ++i) {
                out.writeLong(this.list.getLong(i));
            }
        }

        public void readFields(DataInput in) throws IOException {
            int size = in.readInt();
            this.list.clear();
            this.setCapacity(size);
            for (int i = 0; i < size; ++i) {
                this.list.add(in.readLong());
            }
        }
    }

    public static final class BasicIntArrayList
    extends BasicArrayList<IntWritable> {
        private final IntArrayList list;

        public BasicIntArrayList(int capacity) {
            this.list = new IntArrayList(capacity);
        }

        @Override
        public PrimitiveTypeOps<IntWritable> getElementTypeOps() {
            return IntTypeOps.INSTANCE;
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public int capacity() {
            return this.list.elements().length;
        }

        @Override
        public void setCapacity(int n) {
            if (n >= this.list.elements().length) {
                this.list.ensureCapacity(n);
            } else {
                this.list.trim(n);
            }
        }

        @Override
        public void add(IntWritable value) {
            this.list.add(value.get());
        }

        @Override
        public void getInto(int index, IntWritable to) {
            to.set(this.list.getInt(index));
        }

        @Override
        public void popInto(IntWritable to) {
            to.set(this.list.popInt());
        }

        @Override
        public void set(int index, IntWritable value) {
            this.list.set(index, value.get());
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.list.size());
            for (int i = 0; i < this.list.size(); ++i) {
                out.writeInt(this.list.getInt(i));
            }
        }

        public void readFields(DataInput in) throws IOException {
            int size = in.readInt();
            this.list.clear();
            this.setCapacity(size);
            for (int i = 0; i < size; ++i) {
                this.list.add(in.readInt());
            }
        }
    }

    public static final class BasicByteArrayList
    extends BasicArrayList<ByteWritable> {
        private final ByteArrayList list;

        public BasicByteArrayList(int capacity) {
            this.list = new ByteArrayList(capacity);
        }

        @Override
        public PrimitiveTypeOps<ByteWritable> getElementTypeOps() {
            return ByteTypeOps.INSTANCE;
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public int capacity() {
            return this.list.elements().length;
        }

        @Override
        public void setCapacity(int n) {
            if (n >= this.list.elements().length) {
                this.list.ensureCapacity(n);
            } else {
                this.list.trim(n);
            }
        }

        @Override
        public void add(ByteWritable value) {
            this.list.add(value.get());
        }

        @Override
        public void getInto(int index, ByteWritable to) {
            to.set(this.list.getByte(index));
        }

        @Override
        public void popInto(ByteWritable to) {
            to.set(this.list.popByte());
        }

        @Override
        public void set(int index, ByteWritable value) {
            this.list.set(index, value.get());
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.list.size());
            for (int i = 0; i < this.list.size(); ++i) {
                out.writeByte(this.list.getByte(i));
            }
        }

        public void readFields(DataInput in) throws IOException {
            int size = in.readInt();
            this.list.clear();
            this.setCapacity(size);
            for (int i = 0; i < size; ++i) {
                this.list.add(in.readByte());
            }
        }
    }

    public static final class BasicBooleanArrayList
    extends BasicArrayList<BooleanWritable> {
        private final BooleanArrayList list;

        public BasicBooleanArrayList(int capacity) {
            this.list = new BooleanArrayList(capacity);
        }

        @Override
        public PrimitiveTypeOps<BooleanWritable> getElementTypeOps() {
            return BooleanTypeOps.INSTANCE;
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public int capacity() {
            return this.list.elements().length;
        }

        @Override
        public void setCapacity(int n) {
            if (n >= this.list.elements().length) {
                this.list.ensureCapacity(n);
            } else {
                this.list.trim(n);
            }
        }

        @Override
        public void add(BooleanWritable value) {
            this.list.add(value.get());
        }

        @Override
        public void getInto(int index, BooleanWritable to) {
            to.set(this.list.getBoolean(index));
        }

        @Override
        public void popInto(BooleanWritable to) {
            to.set(this.list.popBoolean());
        }

        @Override
        public void set(int index, BooleanWritable value) {
            this.list.set(index, value.get());
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.list.size());
            for (int i = 0; i < this.list.size(); ++i) {
                out.writeBoolean(this.list.getBoolean(i));
            }
        }

        public void readFields(DataInput in) throws IOException {
            int size = in.readInt();
            this.list.clear();
            this.setCapacity(size);
            for (int i = 0; i < size; ++i) {
                this.list.add(in.readBoolean());
            }
        }
    }
}

