/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.types.ops.collections;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.giraph.types.ops.IntTypeOps;
import org.apache.giraph.types.ops.LongTypeOps;
import org.apache.giraph.types.ops.PrimitiveIdTypeOps;
import org.apache.giraph.types.ops.collections.WritableWriter;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;

public abstract class Basic2ObjectMap<K, V> {
    public abstract void clear();

    public abstract int size();

    public abstract boolean containsKey(K var1);

    public abstract V put(K var1, V var2);

    public abstract V get(K var1);

    public abstract V remove(K var1);

    public abstract PrimitiveIdTypeOps<K> getKeyTypeOps();

    public abstract Iterator<K> fastKeyIterator();

    public abstract void write(DataOutput var1, WritableWriter<V> var2) throws IOException;

    public abstract void readFields(DataInput var1, WritableWriter<V> var2) throws IOException;

    public static final class BasicLong2ObjectOpenHashMap<V>
    extends Basic2ObjectMap<LongWritable, V> {
        private final Long2ObjectOpenHashMap<V> map;

        public BasicLong2ObjectOpenHashMap(int capacity) {
            this.map = new Long2ObjectOpenHashMap(capacity);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean containsKey(LongWritable key) {
            return this.map.containsKey(key.get());
        }

        @Override
        public V put(LongWritable key, V value) {
            return (V)this.map.put(key.get(), value);
        }

        @Override
        public V get(LongWritable key) {
            return (V)this.map.get(key.get());
        }

        @Override
        public V remove(LongWritable key) {
            return (V)this.map.remove(key.get());
        }

        @Override
        public PrimitiveIdTypeOps<LongWritable> getKeyTypeOps() {
            return LongTypeOps.INSTANCE;
        }

        @Override
        public Iterator<LongWritable> fastKeyIterator() {
            return new ReusableIterator<LongIterator>(this.map.keySet().iterator()){

                @Override
                public LongWritable next() {
                    ((LongWritable)this.reusableKey).set(((LongIterator)this.iter).nextLong());
                    return (LongWritable)this.reusableKey;
                }
            };
        }

        @Override
        public void write(DataOutput out, WritableWriter<V> writer) throws IOException {
            out.writeInt(this.map.size());
            ObjectIterator iterator = this.map.long2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
                out.writeLong(entry.getLongKey());
                writer.write(out, entry.getValue());
            }
        }

        @Override
        public void readFields(DataInput in, WritableWriter<V> writer) throws IOException {
            int size = in.readInt();
            this.map.clear();
            this.map.trim(size);
            while (size-- > 0) {
                long key = in.readLong();
                V value = writer.readFields(in);
                this.map.put(key, value);
            }
        }
    }

    public static final class BasicInt2ObjectOpenHashMap<V>
    extends Basic2ObjectMap<IntWritable, V> {
        private final Int2ObjectOpenHashMap<V> map;

        public BasicInt2ObjectOpenHashMap(int capacity) {
            this.map = new Int2ObjectOpenHashMap(capacity);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean containsKey(IntWritable key) {
            return this.map.containsKey(key.get());
        }

        @Override
        public V put(IntWritable key, V value) {
            return (V)this.map.put(key.get(), value);
        }

        @Override
        public V get(IntWritable key) {
            return (V)this.map.get(key.get());
        }

        @Override
        public V remove(IntWritable key) {
            return (V)this.map.remove(key.get());
        }

        @Override
        public PrimitiveIdTypeOps<IntWritable> getKeyTypeOps() {
            return IntTypeOps.INSTANCE;
        }

        @Override
        public Iterator<IntWritable> fastKeyIterator() {
            return new ReusableIterator<IntIterator>(this.map.keySet().iterator()){

                @Override
                public IntWritable next() {
                    ((IntWritable)this.reusableKey).set(((IntIterator)this.iter).nextInt());
                    return (IntWritable)this.reusableKey;
                }
            };
        }

        @Override
        public void write(DataOutput out, WritableWriter<V> writer) throws IOException {
            out.writeInt(this.map.size());
            ObjectIterator iterator = this.map.int2ObjectEntrySet().fastIterator();
            while (iterator.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
                out.writeInt(entry.getIntKey());
                writer.write(out, entry.getValue());
            }
        }

        @Override
        public void readFields(DataInput in, WritableWriter<V> writer) throws IOException {
            int size = in.readInt();
            this.map.clear();
            this.map.trim(size);
            while (size-- > 0) {
                int key = in.readInt();
                V value = writer.readFields(in);
                this.map.put(key, value);
            }
        }
    }

    protected static abstract class ReusableIterator<Iter extends Iterator<?>>
    implements Iterator<K> {
        protected final Iter iter;
        protected final K reusableKey;
        final /* synthetic */ Basic2ObjectMap this$0;

        public ReusableIterator(Iter iter) {
            this.this$0 = var1_1;
            this.reusableKey = this.this$0.getKeyTypeOps().create();
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

