/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.types.ops;

import org.apache.giraph.types.ops.BooleanTypeOps;
import org.apache.giraph.types.ops.ByteTypeOps;
import org.apache.giraph.types.ops.DoubleTypeOps;
import org.apache.giraph.types.ops.FloatTypeOps;
import org.apache.giraph.types.ops.IntTypeOps;
import org.apache.giraph.types.ops.LongTypeOps;
import org.apache.giraph.types.ops.MapTypeOps;
import org.apache.giraph.types.ops.PrimitiveIdTypeOps;
import org.apache.giraph.types.ops.PrimitiveTypeOps;
import org.apache.giraph.types.ops.TextTypeOps;
import org.apache.giraph.types.ops.TypeOps;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;

public class TypeOpsUtils {
    private TypeOpsUtils() {
    }

    public static <T> PrimitiveIdTypeOps<T> getPrimitiveIdTypeOpsOrNull(Class<T> type) {
        if (type.equals(LongWritable.class)) {
            return LongTypeOps.INSTANCE;
        }
        if (type.equals(IntWritable.class)) {
            return IntTypeOps.INSTANCE;
        }
        return null;
    }

    public static <T> PrimitiveIdTypeOps<T> getPrimitiveIdTypeOps(Class<T> type) {
        PrimitiveIdTypeOps<T> typeOps = TypeOpsUtils.getPrimitiveIdTypeOpsOrNull(type);
        if (typeOps != null) {
            return typeOps;
        }
        throw new IllegalArgumentException(type + " not supported in PrimitiveIdTypeOps");
    }

    public static <T> PrimitiveTypeOps<T> getPrimitiveTypeOpsOrNull(Class<T> type) {
        PrimitiveIdTypeOps<T> typeOps = TypeOpsUtils.getPrimitiveIdTypeOpsOrNull(type);
        if (typeOps != null) {
            return typeOps;
        }
        if (type.equals(FloatWritable.class)) {
            return FloatTypeOps.INSTANCE;
        }
        if (type.equals(DoubleWritable.class)) {
            return DoubleTypeOps.INSTANCE;
        }
        if (type.equals(BooleanWritable.class)) {
            return BooleanTypeOps.INSTANCE;
        }
        if (type.equals(ByteWritable.class)) {
            return ByteTypeOps.INSTANCE;
        }
        return null;
    }

    public static <T> PrimitiveTypeOps<T> getPrimitiveTypeOps(Class<T> type) {
        PrimitiveTypeOps<T> typeOps = TypeOpsUtils.getPrimitiveTypeOpsOrNull(type);
        if (typeOps != null) {
            return typeOps;
        }
        throw new IllegalArgumentException(type + " not supported in PrimitiveTypeOps");
    }

    public static <T> TypeOps<T> getTypeOpsOrNull(Class<T> type) {
        PrimitiveTypeOps<T> typeOps = TypeOpsUtils.getPrimitiveTypeOpsOrNull(type);
        if (typeOps != null) {
            return typeOps;
        }
        if (type.equals(Text.class)) {
            return TextTypeOps.INSTANCE;
        }
        if (type.equals(MapWritable.class)) {
            return MapTypeOps.INSTANCE;
        }
        return null;
    }

    public static <T> TypeOps<T> getTypeOps(Class<T> type) {
        TypeOps<T> typeOps = TypeOpsUtils.getTypeOpsOrNull(type);
        if (typeOps != null) {
            return typeOps;
        }
        throw new IllegalArgumentException(type + " not supported in TypeOps");
    }
}

