/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.types;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.giraph.types.BooleanToBooleanWritableWrapper;
import org.apache.giraph.types.ByteToByteWritableWrapper;
import org.apache.giraph.types.ByteToIntWritableWrapper;
import org.apache.giraph.types.ByteToLongWritableWrapper;
import org.apache.giraph.types.DoubleToDoubleWritableWrapper;
import org.apache.giraph.types.FloatToDoubleWritableWrapper;
import org.apache.giraph.types.FloatToFloatWritableWrapper;
import org.apache.giraph.types.IntToIntWritableWrapper;
import org.apache.giraph.types.IntToLongWritableWrapper;
import org.apache.giraph.types.JavaWritablePair;
import org.apache.giraph.types.LongToLongWritableWrapper;
import org.apache.giraph.types.ShortToIntWritableWrapper;
import org.apache.giraph.types.ShortToLongWritableWrapper;
import org.apache.giraph.types.WritableWrapper;
import org.apache.hadoop.io.Writable;

public class WritableWrappers {
    private static final Map<JavaWritablePair, WritableWrapper> MAP = Maps.newHashMap();

    private WritableWrappers() {
    }

    public static <W extends Writable, J> WritableWrapper<W, J> lookup(Class<W> writableClass, Class<J> javaClass) {
        return WritableWrappers.lookup(JavaWritablePair.create(writableClass, javaClass));
    }

    public static <W extends Writable, J> WritableWrapper<W, J> lookup(JavaWritablePair<W, J> classes) {
        return MAP.get(classes);
    }

    static {
        MAP.put(JavaWritablePair.BOOLEAN_BOOLEAN_WRITABLE, new BooleanToBooleanWritableWrapper());
        MAP.put(JavaWritablePair.BYTE_BYTE_WRITABLE, new ByteToByteWritableWrapper());
        MAP.put(JavaWritablePair.BYTE_INT_WRITABLE, new ByteToIntWritableWrapper());
        MAP.put(JavaWritablePair.BYTE_LONG_WRITABLE, new ByteToLongWritableWrapper());
        MAP.put(JavaWritablePair.DOUBLE_DOUBLE_WRITABLE, new DoubleToDoubleWritableWrapper());
        MAP.put(JavaWritablePair.FLOAT_DOUBLE_WRITABLE, new FloatToDoubleWritableWrapper());
        MAP.put(JavaWritablePair.FLOAT_FLOAT_WRITABLE, new FloatToFloatWritableWrapper());
        MAP.put(JavaWritablePair.INT_INT_WRITABLE, new IntToIntWritableWrapper());
        MAP.put(JavaWritablePair.INT_LONG_WRITABLE, new IntToLongWritableWrapper());
        MAP.put(JavaWritablePair.LONG_LONG_WRITABLE, new LongToLongWritableWrapper());
        MAP.put(JavaWritablePair.SHORT_INT_WRITABLE, new ShortToIntWritableWrapper());
        MAP.put(JavaWritablePair.SHORT_LONG_WRITABLE, new ShortToLongWritableWrapper());
    }
}

