/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.types;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.giraph.types.BooleanWritableToBooleanUnwrapper;
import org.apache.giraph.types.ByteWritableToByteUnwrapper;
import org.apache.giraph.types.ByteWritableToIntUnwrapper;
import org.apache.giraph.types.ByteWritableToLongUnwrapper;
import org.apache.giraph.types.ByteWritableToShortUnwrapper;
import org.apache.giraph.types.DoubleWritableToDoubleUnwrapper;
import org.apache.giraph.types.FloatWritableToDoubleUnwrapper;
import org.apache.giraph.types.FloatWritableToFloatUnwrapper;
import org.apache.giraph.types.IntWritableToIntUnwrapper;
import org.apache.giraph.types.IntWritableToLongUnwrapper;
import org.apache.giraph.types.JavaWritablePair;
import org.apache.giraph.types.LongWritableToLongUnwrapper;
import org.apache.giraph.types.WritableUnwrapper;
import org.apache.hadoop.io.Writable;

public class WritableUnwrappers {
    private static final Map<JavaWritablePair, WritableUnwrapper> MAP = Maps.newHashMap();

    private WritableUnwrappers() {
    }

    public static <W extends Writable, J> WritableUnwrapper<W, J> lookup(Class<W> writableClass, Class<J> javaClass) {
        return WritableUnwrappers.lookup(JavaWritablePair.create(writableClass, javaClass));
    }

    public static <W extends Writable, J> WritableUnwrapper<W, J> lookup(JavaWritablePair<W, J> classes) {
        return MAP.get(classes);
    }

    static {
        MAP.put(JavaWritablePair.BOOLEAN_BOOLEAN_WRITABLE, new BooleanWritableToBooleanUnwrapper());
        MAP.put(JavaWritablePair.BYTE_BYTE_WRITABLE, new ByteWritableToByteUnwrapper());
        MAP.put(JavaWritablePair.DOUBLE_DOUBLE_WRITABLE, new DoubleWritableToDoubleUnwrapper());
        MAP.put(JavaWritablePair.DOUBLE_FLOAT_WRITABLE, new FloatWritableToDoubleUnwrapper());
        MAP.put(JavaWritablePair.FLOAT_FLOAT_WRITABLE, new FloatWritableToFloatUnwrapper());
        MAP.put(JavaWritablePair.INT_BYTE_WRITABLE, new ByteWritableToIntUnwrapper());
        MAP.put(JavaWritablePair.INT_INT_WRITABLE, new IntWritableToIntUnwrapper());
        MAP.put(JavaWritablePair.SHORT_BYTE_WRITABLE, new ByteWritableToShortUnwrapper());
        MAP.put(JavaWritablePair.LONG_BYTE_WRITABLE, new ByteWritableToLongUnwrapper());
        MAP.put(JavaWritablePair.LONG_INT_WRITABLE, new IntWritableToLongUnwrapper());
        MAP.put(JavaWritablePair.LONG_LONG_WRITABLE, new LongWritableToLongUnwrapper());
    }
}

