/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.types;

import com.google.common.base.Objects;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

public class JavaWritablePair<W extends Writable, J> {
    public static final JavaWritablePair<BooleanWritable, Boolean> BOOLEAN_BOOLEAN_WRITABLE = JavaWritablePair.create(BooleanWritable.class, Boolean.class);
    public static final JavaWritablePair<ByteWritable, Byte> BYTE_BYTE_WRITABLE = JavaWritablePair.create(ByteWritable.class, Byte.class);
    public static final JavaWritablePair<IntWritable, Byte> BYTE_INT_WRITABLE = JavaWritablePair.create(IntWritable.class, Byte.class);
    public static final JavaWritablePair<LongWritable, Byte> BYTE_LONG_WRITABLE = JavaWritablePair.create(LongWritable.class, Byte.class);
    public static final JavaWritablePair<FloatWritable, Double> DOUBLE_FLOAT_WRITABLE = JavaWritablePair.create(FloatWritable.class, Double.class);
    public static final JavaWritablePair<DoubleWritable, Double> DOUBLE_DOUBLE_WRITABLE = JavaWritablePair.create(DoubleWritable.class, Double.class);
    public static final JavaWritablePair<FloatWritable, Float> FLOAT_FLOAT_WRITABLE = JavaWritablePair.create(FloatWritable.class, Float.class);
    public static final JavaWritablePair<DoubleWritable, Float> FLOAT_DOUBLE_WRITABLE = JavaWritablePair.create(DoubleWritable.class, Float.class);
    public static final JavaWritablePair<ByteWritable, Integer> INT_BYTE_WRITABLE = JavaWritablePair.create(ByteWritable.class, Integer.class);
    public static final JavaWritablePair<IntWritable, Integer> INT_INT_WRITABLE = JavaWritablePair.create(IntWritable.class, Integer.class);
    public static final JavaWritablePair<LongWritable, Integer> INT_LONG_WRITABLE = JavaWritablePair.create(LongWritable.class, Integer.class);
    public static final JavaWritablePair<ByteWritable, Long> LONG_BYTE_WRITABLE = JavaWritablePair.create(ByteWritable.class, Long.class);
    public static final JavaWritablePair<IntWritable, Long> LONG_INT_WRITABLE = JavaWritablePair.create(IntWritable.class, Long.class);
    public static final JavaWritablePair<LongWritable, Long> LONG_LONG_WRITABLE = JavaWritablePair.create(LongWritable.class, Long.class);
    public static final JavaWritablePair<ByteWritable, Short> SHORT_BYTE_WRITABLE = JavaWritablePair.create(ByteWritable.class, Short.class);
    public static final JavaWritablePair<IntWritable, Short> SHORT_INT_WRITABLE = JavaWritablePair.create(IntWritable.class, Short.class);
    public static final JavaWritablePair<LongWritable, Short> SHORT_LONG_WRITABLE = JavaWritablePair.create(LongWritable.class, Short.class);
    private final Class<J> javaClass;
    private final Class<W> writableClass;

    private JavaWritablePair(Class<W> writableClass, Class<J> javaClass) {
        this.javaClass = javaClass;
        this.writableClass = writableClass;
    }

    public static <W extends Writable, J> JavaWritablePair<W, J> create(Class<W> writableClass, Class<J> javaClass) {
        return new JavaWritablePair<W, J>(writableClass, javaClass);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JavaWritablePair) {
            JavaWritablePair other = (JavaWritablePair)obj;
            return Objects.equal(this.javaClass, other.javaClass) && Objects.equal(this.writableClass, other.writableClass);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.javaClass, this.writableClass});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("javaClass", (Object)this.javaClass.getSimpleName()).add("writableClass", (Object)this.writableClass.getSimpleName()).toString();
    }

    public Class<J> getJavaClass() {
        return this.javaClass;
    }

    public Class<W> getWritableClass() {
        return this.writableClass;
    }
}

