/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.time;

import java.util.concurrent.TimeUnit;
import org.apache.giraph.time.Time;

public class Times {
    private Times() {
    }

    public static long get(Time time, TimeUnit timeUnit) {
        return timeUnit.convert(time.getNanoseconds(), TimeUnit.NANOSECONDS);
    }

    public static long getDiff(Time time, TimeUnit timeUnit, long startTime) {
        return Times.get(time, timeUnit) - startTime;
    }

    public static long getMillisecondsSince(Time time, long previousMilliseconds) {
        return time.getMilliseconds() - previousMilliseconds;
    }

    public static long getMsSince(Time time, long previousMs) {
        return Times.getMillisecondsSince(time, previousMs);
    }

    public static long getMicrosSince(Time time, long previousMicros) {
        return time.getMicroseconds() - previousMicros;
    }

    public static long getNanosecondsSince(Time time, long previousNanoseconds) {
        return time.getNanoseconds() - previousNanoseconds;
    }

    public static long getNanosSince(Time time, long previousNanos) {
        return Times.getNanosecondsSince(time, previousNanos);
    }

    public static int getSecondsSince(Time time, int previousSeconds) {
        return time.getSeconds() - previousSeconds;
    }

    public static int getSecSince(Time time, int previousSec) {
        return Times.getSecondsSince(time, previousSec);
    }
}

