/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.time;

import java.util.Date;
import org.apache.giraph.time.Time;

public class SystemTime
implements Time {
    private static final SystemTime SINGLE_TIME = new SystemTime();

    @Override
    public long getMilliseconds() {
        return System.currentTimeMillis();
    }

    @Override
    public long getMicroseconds() {
        return this.getNanoseconds() / 1000L;
    }

    @Override
    public long getNanoseconds() {
        return System.nanoTime();
    }

    @Override
    public int getSeconds() {
        return (int)(this.getMilliseconds() / 1000L);
    }

    @Override
    public Date getCurrentDate() {
        return new Date();
    }

    @Override
    public void sleep(long milliseconds) throws InterruptedException {
        Thread.sleep(milliseconds);
    }

    public static Time get() {
        return SINGLE_TIME;
    }
}

