/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.scripting;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.giraph.conf.JsonStringConfOption;
import org.apache.giraph.graph.Language;
import org.apache.giraph.jython.JythonUtils;
import org.apache.giraph.scripting.DeployType;
import org.apache.giraph.scripting.DeployedScript;
import org.apache.giraph.utils.DistributedCacheUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.codehaus.jackson.type.TypeReference;

public class ScriptLoader {
    public static final JsonStringConfOption SCRIPTS_TO_LOAD = new JsonStringConfOption("giraph.scripts.to.load", "Scripts to load on workers");
    private static final List<DeployedScript> LOADED_SCRIPTS = Lists.newArrayList();
    private static final Logger LOG = Logger.getLogger(ScriptLoader.class);

    private ScriptLoader() {
    }

    public static void setScriptsToLoad(Configuration conf, String scriptPath, DeployType deployType, Language language) {
        DeployedScript deployedScript = new DeployedScript(scriptPath, deployType, language);
        ScriptLoader.setScriptsToLoad(conf, deployedScript);
    }

    public static void setScriptsToLoad(Configuration conf, String script1, DeployType deployType1, Language language1, String script2, DeployType deployType2, Language language2) {
        DeployedScript deployedScript1 = new DeployedScript(script1, deployType1, language1);
        DeployedScript deployedScript2 = new DeployedScript(script2, deployType2, language2);
        ScriptLoader.setScriptsToLoad(conf, deployedScript1, deployedScript2);
    }

    public static void setScriptsToLoad(Configuration conf, DeployedScript ... scripts) {
        ArrayList scriptsToLoad = Lists.newArrayList((Object[])scripts);
        SCRIPTS_TO_LOAD.set(conf, scriptsToLoad);
    }

    public static void addScriptToLoad(Configuration conf, String script, DeployType deployType, Language language) {
        ScriptLoader.addScriptToLoad(conf, new DeployedScript(script, deployType, language));
    }

    public static void addScriptToLoad(Configuration conf, DeployedScript script) {
        ArrayList scriptsToLoad = ScriptLoader.getScriptsToLoad(conf);
        if (scriptsToLoad == null) {
            scriptsToLoad = Lists.newArrayList();
        }
        scriptsToLoad.add(script);
        SCRIPTS_TO_LOAD.set(conf, scriptsToLoad);
    }

    public static List<DeployedScript> getScriptsToLoad(Configuration conf) {
        TypeReference<List<DeployedScript>> jsonType = new TypeReference<List<DeployedScript>>(){};
        return SCRIPTS_TO_LOAD.get(conf, jsonType);
    }

    public static void loadScripts(Configuration conf) throws IOException {
        List<DeployedScript> deployedScripts = ScriptLoader.getScriptsToLoad(conf);
        if (deployedScripts == null) {
            return;
        }
        for (DeployedScript deployedScript : deployedScripts) {
            ScriptLoader.loadScript(conf, deployedScript);
        }
    }

    public static void loadScript(Configuration conf, DeployedScript deployedScript) throws IOException {
        InputStream stream = ScriptLoader.openScriptInputStream(conf, deployedScript);
        switch (deployedScript.getLanguage()) {
            case JYTHON: {
                ScriptLoader.loadJythonScript(stream);
                break;
            }
            default: {
                LOG.fatal((Object)("Don't know how to load script " + deployedScript));
                throw new IllegalStateException("Don't know how to load script " + deployedScript);
            }
        }
        LOADED_SCRIPTS.add(deployedScript);
        Closeables.close((Closeable)stream, (boolean)true);
    }

    private static void loadJythonScript(InputStream stream) {
        JythonUtils.getInterpreter().execfile(stream);
    }

    public static List<DeployedScript> getLoadedScripts() {
        return LOADED_SCRIPTS;
    }

    private static InputStream openScriptInputStream(Configuration conf, DeployedScript deployedScript) {
        InputStream stream;
        DeployType deployType = deployedScript.getDeployType();
        String path = deployedScript.getPath();
        switch (deployType) {
            case RESOURCE: {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("getScriptStream: Reading script from resource at " + deployedScript.getPath()));
                }
                if ((stream = ScriptLoader.class.getClassLoader().getResourceAsStream(path)) != null) break;
                throw new IllegalStateException("getScriptStream: Failed to open script from resource at " + path);
            }
            case DISTRIBUTED_CACHE: {
                Optional<Path> localPath;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("getScriptStream: Reading script from DistributedCache at " + path));
                }
                if (!(localPath = DistributedCacheUtils.getLocalCacheFile(conf, path)).isPresent()) {
                    throw new IllegalStateException("getScriptStream: Failed to find script in local DistributedCache matching " + path);
                }
                String pathStr = ((Path)localPath.get()).toString();
                try {
                    stream = new BufferedInputStream(new FileInputStream(pathStr));
                    break;
                }
                catch (IOException e) {
                    throw new IllegalStateException("getScriptStream: Failed open script from DistributedCache at " + localPath);
                }
            }
            default: {
                throw new IllegalArgumentException("getScriptStream: Unknown script deployment type: " + (Object)((Object)deployType));
            }
        }
        return stream;
    }
}

