/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.reducers;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.reducers.ReduceOperation;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;

public class Reducer<S, R extends Writable> {
    private ReduceOperation<S, R> reduceOp;
    private R currentValue;

    public Reducer() {
    }

    public Reducer(ReduceOperation<S, R> reduceOp) {
        this.reduceOp = reduceOp;
        this.currentValue = this.createInitialValue();
    }

    public Reducer(ReduceOperation<S, R> reduceOp, R currentValue) {
        this.reduceOp = reduceOp;
        this.currentValue = currentValue;
    }

    public void reduceSingle(S valueToReduce) {
        this.currentValue = this.reduceOp.reduceSingle(this.currentValue, valueToReduce);
    }

    public void reducePartial(R valueToReduce) {
        this.currentValue = this.reduceOp.reducePartial(this.currentValue, valueToReduce);
    }

    public R createInitialValue() {
        R value = this.reduceOp.createInitialValue();
        if (value == null) {
            throw new IllegalStateException("Initial value for reducer cannot be null, but is for " + this.reduceOp);
        }
        return value;
    }

    public ReduceOperation<S, R> getReduceOp() {
        return this.reduceOp;
    }

    public R getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(R currentValue) {
        this.currentValue = currentValue;
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeWritableObject(this.reduceOp, out);
        this.currentValue.write(out);
    }

    public void readFields(DataInput in, ImmutableClassesGiraphConfiguration conf) throws IOException {
        this.reduceOp = (ReduceOperation)WritableUtils.readWritableObject(in, conf);
        this.currentValue = this.createInitialValue();
        this.currentValue.readFields(in);
    }
}

