/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.giraph.partition.BasicPartitionOwner;
import org.apache.giraph.partition.PartitionBalancer;
import org.apache.giraph.partition.PartitionExchange;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.partition.PartitionStats;
import org.apache.giraph.partition.PartitionStore;
import org.apache.giraph.partition.WorkerGraphPartitioner;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public abstract class SimpleWorkerPartitioner<I extends WritableComparable, V extends Writable, E extends Writable>
implements WorkerGraphPartitioner<I, V, E> {
    private static final Logger LOG = Logger.getLogger(SimpleWorkerPartitioner.class);
    private List<PartitionOwner> partitionOwnerList = Lists.newArrayList();
    private Set<WorkerInfo> availableWorkers = new HashSet<WorkerInfo>();

    @Override
    public PartitionOwner createPartitionOwner() {
        return new BasicPartitionOwner();
    }

    @Override
    public PartitionOwner getPartitionOwner(I vertexId) {
        return this.partitionOwnerList.get(this.getPartitionIndex(vertexId, this.partitionOwnerList.size(), this.availableWorkers.size()));
    }

    @Override
    public Collection<PartitionStats> finalizePartitionStats(Collection<PartitionStats> workerPartitionStats, PartitionStore<I, V, E> partitionStore) {
        return workerPartitionStats;
    }

    @Override
    public PartitionExchange updatePartitionOwners(WorkerInfo myWorkerInfo, Collection<? extends PartitionOwner> masterSetPartitionOwners) {
        PartitionExchange exchange = PartitionBalancer.updatePartitionOwners(this.partitionOwnerList, myWorkerInfo, masterSetPartitionOwners);
        this.extractAvailableWorkers();
        return exchange;
    }

    @Override
    public Collection<? extends PartitionOwner> getPartitionOwners() {
        return this.partitionOwnerList;
    }

    public void extractAvailableWorkers() {
        this.availableWorkers.clear();
        for (PartitionOwner partitionOwner : this.partitionOwnerList) {
            this.availableWorkers.add(partitionOwner.getWorkerInfo());
        }
        LOG.info((Object)("After updating partitionOwnerList " + this.availableWorkers.size() + " workers are available"));
    }

    protected abstract int getPartitionIndex(I var1, int var2, int var3);
}

