/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import org.apache.giraph.conf.DefaultImmutableClassesGiraphConfigurable;
import org.apache.giraph.partition.GraphPartitionerFactory;
import org.apache.giraph.partition.MasterGraphPartitioner;
import org.apache.giraph.partition.SimpleMasterPartitioner;
import org.apache.giraph.partition.SimpleWorkerPartitioner;
import org.apache.giraph.partition.WorkerGraphPartitioner;
import org.apache.giraph.worker.LocalData;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public abstract class SimplePartitionerFactory<I extends WritableComparable, V extends Writable, E extends Writable>
extends DefaultImmutableClassesGiraphConfigurable<I, V, E>
implements GraphPartitionerFactory<I, V, E> {
    @Override
    public void initialize(LocalData<I, V, E, ? extends Writable> localData) {
    }

    @Override
    public final MasterGraphPartitioner<I, V, E> createMasterGraphPartitioner() {
        return new SimpleMasterPartitioner<I, V, E>(this.getConf()){

            @Override
            protected int getWorkerIndex(int partition, int partitionCount, int workerCount) {
                return SimplePartitionerFactory.this.getWorker(partition, partitionCount, workerCount);
            }
        };
    }

    @Override
    public final WorkerGraphPartitioner<I, V, E> createWorkerGraphPartitioner() {
        return new SimpleWorkerPartitioner<I, V, E>(){

            @Override
            protected int getPartitionIndex(I id, int partitionCount, int workerCount) {
                return SimplePartitionerFactory.this.getPartition(id, partitionCount, workerCount);
            }
        };
    }

    protected abstract int getPartition(I var1, int var2, int var3);

    protected abstract int getWorker(int var1, int var2, int var3);

    public static int getPartitionInRange(int value, int max, int partitions) {
        double keyRange = (double)max / (double)partitions;
        int part = (int)((double)(value % max) / keyRange);
        return Math.max(0, Math.min(partitions - 1, part));
    }

    public static int getPartitionInRange(long value, long max, int partitions) {
        double keyRange = (double)max / (double)partitions;
        int part = (int)((double)(value % max) / keyRange);
        return Math.max(0, Math.min(partitions - 1, part));
    }
}

