/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.partition.PartitionStore;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Progressable;

public class SimplePartitionStore<I extends WritableComparable, V extends Writable, E extends Writable>
extends PartitionStore<I, V, E> {
    private final ConcurrentMap<Integer, Partition<I, V, E>> partitions = Maps.newConcurrentMap();
    private final ImmutableClassesGiraphConfiguration<I, V, E> conf;
    private final Mapper.Context context;

    public SimplePartitionStore(ImmutableClassesGiraphConfiguration<I, V, E> conf, Mapper.Context context) {
        this.conf = conf;
        this.context = context;
    }

    @Override
    public void addPartition(Partition<I, V, E> partition) {
        Partition<I, V, E> oldPartition = (Partition<I, V, E>)this.partitions.get(partition.getId());
        if (oldPartition == null && (oldPartition = this.partitions.putIfAbsent(partition.getId(), partition)) == null) {
            return;
        }
        oldPartition.addPartition(partition);
    }

    @Override
    public Partition<I, V, E> getOrCreatePartition(Integer partitionId) {
        Partition<I, V, E> newPartition;
        Partition<I, V, E> oldPartition = (Partition<I, V, E>)this.partitions.get(partitionId);
        if (oldPartition == null && (oldPartition = this.partitions.putIfAbsent(partitionId, newPartition = this.conf.createPartition(partitionId, (Progressable)this.context))) == null) {
            return newPartition;
        }
        return oldPartition;
    }

    @Override
    public Partition<I, V, E> removePartition(Integer partitionId) {
        return (Partition)this.partitions.remove(partitionId);
    }

    @Override
    public void deletePartition(Integer partitionId) {
        this.partitions.remove(partitionId);
    }

    @Override
    public boolean hasPartition(Integer partitionId) {
        return this.partitions.containsKey(partitionId);
    }

    @Override
    public Iterable<Integer> getPartitionIds() {
        return this.partitions.keySet();
    }

    @Override
    public int getNumPartitions() {
        return this.partitions.size();
    }

    @Override
    public void putPartition(Partition<I, V, E> partition) {
    }
}

