/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.giraph.comm.messages.MessageStoreFactory;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.partition.BasicPartition;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.utils.ReflectionUtils;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.Progressable;

@ThreadSafe
public class SimplePartition<I extends WritableComparable, V extends Writable, E extends Writable>
extends BasicPartition<I, V, E> {
    private ConcurrentMap<I, Vertex<I, V, E>> vertexMap;

    @Override
    public void initialize(int partitionId, Progressable progressable) {
        super.initialize(partitionId, progressable);
        this.vertexMap = this.shouldTraverseMessageInOrder() ? new ConcurrentSkipListMap<I, Vertex<I, V, E>>() : Maps.newConcurrentMap();
    }

    @Override
    public Vertex<I, V, E> getVertex(I vertexIndex) {
        return (Vertex)this.vertexMap.get(vertexIndex);
    }

    @Override
    public Vertex<I, V, E> putVertex(Vertex<I, V, E> vertex) {
        return this.vertexMap.put(vertex.getId(), vertex);
    }

    @Override
    public Vertex<I, V, E> removeVertex(I vertexIndex) {
        return (Vertex)this.vertexMap.remove(vertexIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putOrCombine(Vertex<I, V, E> vertex) {
        Vertex<I, V, E> originalVertex = (Vertex<I, V, E>)this.vertexMap.get(vertex.getId());
        if (originalVertex == null && (originalVertex = this.vertexMap.putIfAbsent(vertex.getId(), vertex)) == null) {
            return true;
        }
        Vertex<I, V, E> vertex2 = originalVertex;
        synchronized (vertex2) {
            this.getVertexValueCombiner().combine(originalVertex.getValue(), vertex.getValue());
            for (Edge<I, E> edge : vertex.getEdges()) {
                originalVertex.addEdge(edge);
            }
        }
        return false;
    }

    @Override
    public void addPartition(Partition<I, V, E> partition) {
        for (Vertex vertex : partition) {
            this.putOrCombine(vertex);
        }
    }

    @Override
    public long getVertexCount() {
        return this.vertexMap.size();
    }

    @Override
    public long getEdgeCount() {
        long edges = 0L;
        for (Vertex vertex : this.vertexMap.values()) {
            edges += (long)vertex.getNumEdges();
        }
        return edges;
    }

    @Override
    public void saveVertex(Vertex<I, V, E> vertex) {
    }

    public String toString() {
        return "(id=" + this.getId() + ",V=" + this.vertexMap.size() + ")";
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        this.vertexMap = this.shouldTraverseMessageInOrder() ? new ConcurrentSkipListMap<I, Vertex<I, V, E>>() : Maps.newConcurrentMap();
        int vertices = input.readInt();
        for (int i = 0; i < vertices; ++i) {
            this.progress();
            Vertex vertex = WritableUtils.readVertexFromDataInput(input, this.getConf());
            if (this.vertexMap.put(vertex.getId(), vertex) == null) continue;
            throw new IllegalStateException("readFields: " + this + " already has same id " + vertex);
        }
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        output.writeInt(this.vertexMap.size());
        for (Vertex vertex : this.vertexMap.values()) {
            this.progress();
            WritableUtils.writeVertexToDataOutput(output, vertex, this.getConf());
        }
    }

    @Override
    public Iterator<Vertex<I, V, E>> iterator() {
        return this.vertexMap.values().iterator();
    }

    private boolean shouldTraverseMessageInOrder() {
        Class<MessageStoreFactory> messageStoreFactoryClass = GiraphConstants.MESSAGE_STORE_FACTORY_CLASS.get(this.getConf());
        MessageStoreFactory messageStoreFactoryInstance = ReflectionUtils.newInstance(messageStoreFactoryClass);
        return messageStoreFactoryInstance.shouldTraverseMessagesInOrder();
    }
}

