/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.partition.BasicPartitionOwner;
import org.apache.giraph.partition.HashMasterPartitioner;
import org.apache.giraph.partition.MasterGraphPartitioner;
import org.apache.giraph.partition.PartitionBalancer;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.partition.PartitionStats;
import org.apache.giraph.partition.PartitionUtils;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public abstract class SimpleMasterPartitioner<I extends WritableComparable, V extends Writable, E extends Writable>
implements MasterGraphPartitioner<I, V, E> {
    private static Logger LOG = Logger.getLogger(HashMasterPartitioner.class);
    private ImmutableClassesGiraphConfiguration conf;
    private List<PartitionOwner> partitionOwnerList;

    public SimpleMasterPartitioner(ImmutableClassesGiraphConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public Collection<PartitionOwner> createInitialPartitionOwners(Collection<WorkerInfo> availableWorkerInfos, int maxWorkers) {
        int partitionCount = PartitionUtils.computePartitionCount(availableWorkerInfos, maxWorkers, this.conf);
        ArrayList<WorkerInfo> workerList = new ArrayList<WorkerInfo>(availableWorkerInfos);
        this.partitionOwnerList = new ArrayList<PartitionOwner>();
        for (int i = 0; i < partitionCount; ++i) {
            this.partitionOwnerList.add(new BasicPartitionOwner(i, workerList.get(this.getWorkerIndex(i, partitionCount, workerList.size()))));
        }
        return this.partitionOwnerList;
    }

    @Override
    public void setPartitionOwners(Collection<PartitionOwner> partitionOwners) {
        this.partitionOwnerList = Lists.newArrayList(partitionOwners);
    }

    @Override
    public Collection<PartitionOwner> generateChangedPartitionOwners(Collection<PartitionStats> allPartitionStatsList, Collection<WorkerInfo> availableWorkers, int maxWorkers, long superstep) {
        return PartitionBalancer.balancePartitionsAcrossWorkers(this.conf, this.partitionOwnerList, allPartitionStatsList, availableWorkers);
    }

    @Override
    public Collection<PartitionOwner> getCurrentPartitionOwners() {
        return this.partitionOwnerList;
    }

    @Override
    public PartitionStats createPartitionStats() {
        return new PartitionStats();
    }

    protected abstract int getWorkerIndex(int var1, int var2, int var3);
}

