/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.partition.SimplePartitionerFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

public class SimpleLongRangePartitionerFactory<V extends Writable, E extends Writable>
extends SimplePartitionerFactory<LongWritable, V, E> {
    private long keySpaceSize;

    @Override
    protected int getPartition(LongWritable id, int partitionCount, int workerCount) {
        return this.getPartition(id, partitionCount);
    }

    protected int getPartition(LongWritable id, int partitionCount) {
        return SimpleLongRangePartitionerFactory.getPartitionInRange(id.get(), this.keySpaceSize, partitionCount);
    }

    @Override
    protected int getWorker(int partition, int partitionCount, int workerCount) {
        return SimpleLongRangePartitionerFactory.getPartitionInRange(partition, partitionCount, workerCount);
    }

    @Override
    public void setConf(ImmutableClassesGiraphConfiguration conf) {
        super.setConf(conf);
        this.keySpaceSize = conf.getLong("giraph.vertexKeySpaceSize", -1L);
        if (this.keySpaceSize == -1L) {
            throw new IllegalStateException("Need to specify giraph.vertexKeySpaceSize when using SimpleLongRangePartitionerFactory");
        }
    }
}

