/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.partition.SimplePartitionerFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;

public class SimpleIntRangePartitionerFactory<V extends Writable, E extends Writable>
extends SimplePartitionerFactory<IntWritable, V, E> {
    private int keySpaceSize;

    @Override
    protected int getPartition(IntWritable id, int partitionCount, int workerCount) {
        return this.getPartition(id, partitionCount);
    }

    protected int getPartition(IntWritable id, int partitionCount) {
        return SimpleIntRangePartitionerFactory.getPartitionInRange(id.get(), this.keySpaceSize, partitionCount);
    }

    @Override
    protected int getWorker(int partition, int partitionCount, int workerCount) {
        return SimpleIntRangePartitionerFactory.getPartitionInRange(partition, partitionCount, workerCount);
    }

    @Override
    public void setConf(ImmutableClassesGiraphConfiguration conf) {
        super.setConf(conf);
        this.keySpaceSize = conf.getInt("giraph.vertexKeySpaceSize", -1);
        if (this.keySpaceSize == -1) {
            throw new IllegalStateException("Need to specify giraph.vertexKeySpaceSize when using SimpleIntRangePartitionerFactory");
        }
    }
}

