/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.VertexEdgeCount;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.partition.PartitionStats;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.log4j.Logger;

public class PartitionUtils {
    private static Logger LOG = Logger.getLogger(PartitionUtils.class);

    private PartitionUtils() {
    }

    public static void analyzePartitionStats(Collection<PartitionOwner> partitionOwnerList, List<PartitionStats> allPartitionStats) {
        HashMap<Integer, PartitionOwner> idOwnerMap = new HashMap<Integer, PartitionOwner>();
        for (PartitionOwner partitionOwner : partitionOwnerList) {
            if (idOwnerMap.put(partitionOwner.getPartitionId(), partitionOwner) == null) continue;
            throw new IllegalStateException("analyzePartitionStats: Duplicate partition " + partitionOwner);
        }
        HashMap workerStatsMap = Maps.newHashMap();
        VertexEdgeCount totalVertexEdgeCount = new VertexEdgeCount();
        for (PartitionStats partitionStats : allPartitionStats) {
            WorkerInfo workerInfo = ((PartitionOwner)idOwnerMap.get(partitionStats.getPartitionId())).getWorkerInfo();
            VertexEdgeCount vertexEdgeCount = (VertexEdgeCount)workerStatsMap.get(workerInfo);
            if (vertexEdgeCount == null) {
                workerStatsMap.put(workerInfo, new VertexEdgeCount(partitionStats.getVertexCount(), partitionStats.getEdgeCount()));
            } else {
                workerStatsMap.put(workerInfo, vertexEdgeCount.incrVertexEdgeCount(partitionStats.getVertexCount(), partitionStats.getEdgeCount()));
            }
            totalVertexEdgeCount = totalVertexEdgeCount.incrVertexEdgeCount(partitionStats.getVertexCount(), partitionStats.getEdgeCount());
        }
        ArrayList workerEntryList = Lists.newArrayList(workerStatsMap.entrySet());
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry worker : workerEntryList) {
                sb.append(worker.getKey());
                sb.append(":");
                sb.append(worker.getValue());
                sb.append(",");
            }
            LOG.info((Object)("analyzePartitionStats: [" + sb + "]"));
            Collections.sort(workerEntryList, new VertexCountComparator());
            LOG.info((Object)("analyzePartitionStats: Vertices - Mean: " + totalVertexEdgeCount.getVertexCount() / (long)workerStatsMap.size() + ", Min: " + ((Map.Entry)workerEntryList.get(0)).getKey() + " - " + ((VertexEdgeCount)((Map.Entry)workerEntryList.get(0)).getValue()).getVertexCount() + ", Max: " + ((Map.Entry)workerEntryList.get(workerEntryList.size() - 1)).getKey() + " - " + ((VertexEdgeCount)((Map.Entry)workerEntryList.get(workerEntryList.size() - 1)).getValue()).getVertexCount()));
            Collections.sort(workerEntryList, new EdgeCountComparator());
            LOG.info((Object)("analyzePartitionStats: Edges - Mean: " + totalVertexEdgeCount.getEdgeCount() / (long)workerStatsMap.size() + ", Min: " + ((Map.Entry)workerEntryList.get(0)).getKey() + " - " + ((VertexEdgeCount)((Map.Entry)workerEntryList.get(0)).getValue()).getEdgeCount() + ", Max: " + ((Map.Entry)workerEntryList.get(workerEntryList.size() - 1)).getKey() + " - " + ((VertexEdgeCount)((Map.Entry)workerEntryList.get(workerEntryList.size() - 1)).getValue()).getEdgeCount()));
        }
    }

    public static int computePartitionCount(Collection<WorkerInfo> availableWorkerInfos, int maxWorkers, ImmutableClassesGiraphConfiguration conf) {
        int maxPartitions;
        int partitionCount;
        if (availableWorkerInfos.isEmpty()) {
            throw new IllegalArgumentException("computePartitionCount: No available workers");
        }
        int userPartitionCount = GiraphConstants.USER_PARTITION_COUNT.get(conf);
        if (userPartitionCount == GiraphConstants.USER_PARTITION_COUNT.getDefaultValue()) {
            float multiplier = GiraphConstants.PARTITION_COUNT_MULTIPLIER.get(conf);
            partitionCount = Math.max((int)(multiplier * (float)availableWorkerInfos.size() * (float)availableWorkerInfos.size()), 1);
        } else {
            partitionCount = userPartitionCount;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("computePartitionCount: Creating " + partitionCount + ", default would have been " + availableWorkerInfos.size() * availableWorkerInfos.size() + " partitions."));
        }
        if (partitionCount > (maxPartitions = PartitionUtils.getMaxPartitions(conf))) {
            int reducedPartitions = maxPartitions / availableWorkerInfos.size() * availableWorkerInfos.size();
            if (reducedPartitions == 0) {
                reducedPartitions = maxPartitions;
            }
            LOG.warn((Object)("computePartitionCount: Reducing the partitionCount to " + reducedPartitions + " from " + partitionCount + " because of " + maxPartitions + " limit"));
            partitionCount = reducedPartitions;
        }
        return partitionCount;
    }

    private static int getMaxPartitions(ImmutableClassesGiraphConfiguration conf) {
        if (conf.useCheckpointing()) {
            return 5000;
        }
        return 50000;
    }

    private static class VertexCountComparator
    implements Comparator<Map.Entry<WorkerInfo, VertexEdgeCount>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private VertexCountComparator() {
        }

        @Override
        public int compare(Map.Entry<WorkerInfo, VertexEdgeCount> worker1, Map.Entry<WorkerInfo, VertexEdgeCount> worker2) {
            return (int)(worker1.getValue().getVertexCount() - worker2.getValue().getVertexCount());
        }
    }

    private static class EdgeCountComparator
    implements Comparator<Map.Entry<WorkerInfo, VertexEdgeCount>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EdgeCountComparator() {
        }

        @Override
        public int compare(Map.Entry<WorkerInfo, VertexEdgeCount> worker1, Map.Entry<WorkerInfo, VertexEdgeCount> worker2) {
            return (int)(worker1.getValue().getEdgeCount() - worker2.getValue().getEdgeCount());
        }
    }
}

