/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class PartitionStats
implements Writable {
    private int partitionId = -1;
    private long vertexCount = 0L;
    private long finishedVertexCount = 0L;
    private long edgeCount = 0L;
    private long messagesSentCount = 0L;
    private long messageBytesSentCount = 0L;

    public PartitionStats() {
    }

    public PartitionStats(int partitionId, long vertexCount, long finishedVertexCount, long edgeCount, long messagesSentCount, long messageBytesSentCount) {
        this.partitionId = partitionId;
        this.vertexCount = vertexCount;
        this.finishedVertexCount = finishedVertexCount;
        this.edgeCount = edgeCount;
        this.messagesSentCount = messagesSentCount;
        this.messageBytesSentCount = messageBytesSentCount;
    }

    public void setPartitionId(int partitionId) {
        this.partitionId = partitionId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public void incrVertexCount() {
        ++this.vertexCount;
    }

    public long getVertexCount() {
        return this.vertexCount;
    }

    public void incrFinishedVertexCount() {
        ++this.finishedVertexCount;
    }

    public long getFinishedVertexCount() {
        return this.finishedVertexCount;
    }

    public void addEdgeCount(long edgeCount) {
        this.edgeCount += edgeCount;
    }

    public long getEdgeCount() {
        return this.edgeCount;
    }

    public void addMessagesSentCount(long messagesSentCount) {
        this.messagesSentCount += messagesSentCount;
    }

    public long getMessagesSentCount() {
        return this.messagesSentCount;
    }

    public void addMessageBytesSentCount(long messageBytesSentCount) {
        this.messageBytesSentCount += messageBytesSentCount;
    }

    public long getMessageBytesSentCount() {
        return this.messageBytesSentCount;
    }

    public void readFields(DataInput input) throws IOException {
        this.partitionId = input.readInt();
        this.vertexCount = input.readLong();
        this.finishedVertexCount = input.readLong();
        this.edgeCount = input.readLong();
        this.messagesSentCount = input.readLong();
        this.messageBytesSentCount = input.readLong();
    }

    public void write(DataOutput output) throws IOException {
        output.writeInt(this.partitionId);
        output.writeLong(this.vertexCount);
        output.writeLong(this.finishedVertexCount);
        output.writeLong(this.edgeCount);
        output.writeLong(this.messagesSentCount);
        output.writeLong(this.messageBytesSentCount);
    }

    public String toString() {
        return "(id=" + this.partitionId + ",vtx=" + this.vertexCount + ",finVtx=" + this.finishedVertexCount + ",edges=" + this.edgeCount + ",msgsSent=" + this.messagesSentCount + ",msgBytesSent=" + this.messageBytesSentCount + ")";
    }
}

