/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.giraph.partition.PartitionExchange;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.partition.PartitionStats;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class PartitionBalancer {
    public static final String PARTITION_BALANCE_ALGORITHM = "hash.partitionBalanceAlgorithm";
    public static final String STATIC_BALANCE_ALGORITHM = "static";
    public static final String EGDE_BALANCE_ALGORITHM = "edges";
    public static final String VERTICES_BALANCE_ALGORITHM = "vertices";
    private static Logger LOG = Logger.getLogger(PartitionBalancer.class);

    private PartitionBalancer() {
    }

    private static long getBalanceValue(PartitionStats partitionStat, BalanceValue balanceValue) {
        switch (balanceValue) {
            case EDGES: {
                return partitionStat.getEdgeCount();
            }
            case VERTICES: {
                return partitionStat.getVertexCount();
            }
        }
        throw new IllegalArgumentException("getBalanceValue: Illegal balance value " + (Object)((Object)balanceValue));
    }

    public static Collection<PartitionOwner> balancePartitionsAcrossWorkers(Configuration conf, Collection<PartitionOwner> partitionOwners, Collection<PartitionStats> allPartitionStats, Collection<WorkerInfo> availableWorkerInfos) {
        String balanceAlgorithm = conf.get(PARTITION_BALANCE_ALGORITHM, STATIC_BALANCE_ALGORITHM);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("balancePartitionsAcrossWorkers: Using algorithm " + balanceAlgorithm));
        }
        BalanceValue balanceValue = BalanceValue.UNSET;
        if (balanceAlgorithm.equals(STATIC_BALANCE_ALGORITHM)) {
            return partitionOwners;
        }
        if (balanceAlgorithm.equals(EGDE_BALANCE_ALGORITHM)) {
            balanceValue = BalanceValue.EDGES;
        } else if (balanceAlgorithm.equals(VERTICES_BALANCE_ALGORITHM)) {
            balanceValue = BalanceValue.VERTICES;
        } else {
            throw new IllegalArgumentException("balancePartitionsAcrossWorkers: Illegal balance algorithm - " + balanceAlgorithm);
        }
        HashMap<Integer, PartitionStats> idStatMap = new HashMap<Integer, PartitionStats>();
        for (PartitionStats partitionStats : allPartitionStats) {
            if (idStatMap.put(partitionStats.getPartitionId(), partitionStats) == null) continue;
            throw new IllegalStateException("balancePartitionsAcrossWorkers: Duplicate partition id for " + partitionStats);
        }
        HashMap<PartitionOwner, PartitionStats> ownerStatsMap = new HashMap<PartitionOwner, PartitionStats>();
        for (PartitionOwner partitionOwner : partitionOwners) {
            PartitionStats partitionStats = (PartitionStats)idStatMap.get(partitionOwner.getPartitionId());
            if (partitionStats == null) {
                throw new IllegalStateException("balancePartitionsAcrossWorkers: Missing partition stats for " + partitionOwner);
            }
            if (ownerStatsMap.put(partitionOwner, partitionStats) == null) continue;
            throw new IllegalStateException("balancePartitionsAcrossWorkers: Duplicate partition owner " + partitionOwner);
        }
        if (ownerStatsMap.size() != partitionOwners.size()) {
            throw new IllegalStateException("balancePartitionsAcrossWorkers: ownerStats count = " + ownerStatsMap.size() + ", partitionOwners count = " + partitionOwners.size() + " and should match.");
        }
        ArrayList<WorkerInfoAssignments> workerInfoAssignmentsList = new ArrayList<WorkerInfoAssignments>(availableWorkerInfos.size());
        for (WorkerInfo workerInfo : availableWorkerInfos) {
            workerInfoAssignmentsList.add(new WorkerInfoAssignments(workerInfo, balanceValue, ownerStatsMap));
        }
        ArrayList<PartitionOwner> partitionOwnerList = new ArrayList<PartitionOwner>(partitionOwners);
        Collections.sort(partitionOwnerList, Collections.reverseOrder(new PartitionOwnerComparator(ownerStatsMap, balanceValue)));
        PriorityQueue<WorkerInfoAssignments> minQueue = new PriorityQueue<WorkerInfoAssignments>(workerInfoAssignmentsList);
        for (PartitionOwner partitionOwner : partitionOwnerList) {
            WorkerInfoAssignments chosenWorker = (WorkerInfoAssignments)minQueue.remove();
            chosenWorker.assignPartitionOwner(partitionOwner);
            minQueue.add(chosenWorker);
        }
        return partitionOwnerList;
    }

    public static PartitionExchange updatePartitionOwners(List<PartitionOwner> partitionOwnerList, WorkerInfo myWorkerInfo, Collection<? extends PartitionOwner> masterSetPartitionOwners) {
        partitionOwnerList.clear();
        partitionOwnerList.addAll(masterSetPartitionOwners);
        HashSet<WorkerInfo> dependentWorkerSet = new HashSet<WorkerInfo>();
        HashMap<WorkerInfo, List<Integer>> workerPartitionOwnerMap = new HashMap<WorkerInfo, List<Integer>>();
        for (PartitionOwner partitionOwner : masterSetPartitionOwners) {
            if (partitionOwner.getPreviousWorkerInfo() == null) continue;
            if (partitionOwner.getWorkerInfo().equals(myWorkerInfo) && partitionOwner.getPreviousWorkerInfo().equals(myWorkerInfo)) {
                throw new IllegalStateException("updatePartitionOwners: Impossible to have the same previous and current worker info " + partitionOwner + " as me " + myWorkerInfo);
            }
            if (partitionOwner.getWorkerInfo().equals(myWorkerInfo)) {
                dependentWorkerSet.add(partitionOwner.getPreviousWorkerInfo());
                continue;
            }
            if (!partitionOwner.getPreviousWorkerInfo().equals(myWorkerInfo)) continue;
            if (workerPartitionOwnerMap.containsKey(partitionOwner.getWorkerInfo())) {
                ((List)workerPartitionOwnerMap.get(partitionOwner.getWorkerInfo())).add(partitionOwner.getPartitionId());
                continue;
            }
            ArrayList<Integer> tmpPartitionOwnerList = new ArrayList<Integer>();
            tmpPartitionOwnerList.add(partitionOwner.getPartitionId());
            workerPartitionOwnerMap.put(partitionOwner.getWorkerInfo(), tmpPartitionOwnerList);
        }
        return new PartitionExchange(dependentWorkerSet, workerPartitionOwnerMap);
    }

    private static class WorkerInfoAssignments
    implements Comparable<WorkerInfoAssignments> {
        private final WorkerInfo workerInfo;
        private final BalanceValue balanceValue;
        private final Map<PartitionOwner, PartitionStats> ownerStatsMap;
        private long value = 0L;

        public WorkerInfoAssignments(WorkerInfo workerInfo, BalanceValue balanceValue, Map<PartitionOwner, PartitionStats> ownerStatsMap) {
            this.workerInfo = workerInfo;
            this.balanceValue = balanceValue;
            this.ownerStatsMap = ownerStatsMap;
        }

        public long getValue() {
            return this.value;
        }

        public void assignPartitionOwner(PartitionOwner partitionOwner) {
            this.value += PartitionBalancer.getBalanceValue(this.ownerStatsMap.get(partitionOwner), this.balanceValue);
            if (!partitionOwner.getWorkerInfo().equals(this.workerInfo)) {
                partitionOwner.setPreviousWorkerInfo(partitionOwner.getWorkerInfo());
                partitionOwner.setWorkerInfo(this.workerInfo);
            } else {
                partitionOwner.setPreviousWorkerInfo(null);
            }
        }

        @Override
        public int compareTo(WorkerInfoAssignments other) {
            return (int)(this.getValue() - other.getValue());
        }

        public boolean equals(Object obj) {
            return obj instanceof WorkerInfoAssignments && this.compareTo((WorkerInfoAssignments)obj) == 0;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.value});
        }
    }

    private static class PartitionOwnerComparator
    implements Comparator<PartitionOwner> {
        private final Map<PartitionOwner, PartitionStats> ownerStatMap;
        private final BalanceValue balanceValue;

        public PartitionOwnerComparator(Map<PartitionOwner, PartitionStats> ownerStatMap, BalanceValue balanceValue) {
            this.ownerStatMap = ownerStatMap;
            this.balanceValue = balanceValue;
        }

        @Override
        public int compare(PartitionOwner owner1, PartitionOwner owner2) {
            return (int)(PartitionBalancer.getBalanceValue(this.ownerStatMap.get(owner1), this.balanceValue) - PartitionBalancer.getBalanceValue(this.ownerStatMap.get(owner2), this.balanceValue));
        }
    }

    private static enum BalanceValue {
        UNSET,
        EDGES,
        VERTICES;

    }
}

