/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import org.apache.giraph.partition.SimplePartitionerFactory;
import org.apache.giraph.worker.LocalData;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

public class LongMappingStorePartitionerFactory<V extends Writable, E extends Writable>
extends SimplePartitionerFactory<LongWritable, V, E> {
    private static final Logger LOG = Logger.getLogger(LongMappingStorePartitionerFactory.class);
    protected LocalData<LongWritable, V, E, ? extends Writable> localData = null;

    @Override
    public void initialize(LocalData<LongWritable, V, E, ? extends Writable> localData) {
        this.localData = localData;
        LOG.info((Object)"Initializing LongMappingStorePartitionerFactory with localData");
    }

    @Override
    protected int getPartition(LongWritable id, int partitionCount, int workerCount) {
        return this.localData.getMappingStoreOps().getPartition(id, partitionCount, workerCount);
    }

    @Override
    protected int getWorker(int partition, int partitionCount, int workerCount) {
        int numRows = partitionCount / workerCount;
        numRows = numRows * workerCount == partitionCount ? numRows : numRows + 1;
        return partition / numRows;
    }
}

