/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.giraph.partition.BasicPartitionOwner;
import org.apache.giraph.partition.PartitionBalancer;
import org.apache.giraph.partition.PartitionExchange;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.partition.PartitionStats;
import org.apache.giraph.partition.PartitionStore;
import org.apache.giraph.partition.WorkerGraphPartitioner;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class HashWorkerPartitioner<I extends WritableComparable, V extends Writable, E extends Writable>
implements WorkerGraphPartitioner<I, V, E> {
    protected List<PartitionOwner> partitionOwnerList = Lists.newArrayList();

    @Override
    public PartitionOwner createPartitionOwner() {
        return new BasicPartitionOwner();
    }

    @Override
    public PartitionOwner getPartitionOwner(I vertexId) {
        return this.partitionOwnerList.get(Math.abs(vertexId.hashCode() % this.partitionOwnerList.size()));
    }

    @Override
    public Collection<PartitionStats> finalizePartitionStats(Collection<PartitionStats> workerPartitionStats, PartitionStore<I, V, E> partitionStore) {
        return workerPartitionStats;
    }

    @Override
    public PartitionExchange updatePartitionOwners(WorkerInfo myWorkerInfo, Collection<? extends PartitionOwner> masterSetPartitionOwners) {
        return PartitionBalancer.updatePartitionOwners(this.partitionOwnerList, myWorkerInfo, masterSetPartitionOwners);
    }

    @Override
    public Collection<? extends PartitionOwner> getPartitionOwners() {
        return this.partitionOwnerList;
    }
}

