/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.partition.BasicPartitionOwner;
import org.apache.giraph.partition.MasterGraphPartitioner;
import org.apache.giraph.partition.PartitionBalancer;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.partition.PartitionStats;
import org.apache.giraph.partition.PartitionUtils;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class HashMasterPartitioner<I extends WritableComparable, V extends Writable, E extends Writable>
implements MasterGraphPartitioner<I, V, E> {
    private static Logger LOG = Logger.getLogger(HashMasterPartitioner.class);
    private ImmutableClassesGiraphConfiguration conf;
    private List<PartitionOwner> partitionOwnerList;

    public HashMasterPartitioner(ImmutableClassesGiraphConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public Collection<PartitionOwner> createInitialPartitionOwners(Collection<WorkerInfo> availableWorkerInfos, int maxWorkers) {
        int partitionCount = PartitionUtils.computePartitionCount(availableWorkerInfos, maxWorkers, this.conf);
        ArrayList<PartitionOwner> ownerList = new ArrayList<PartitionOwner>();
        Iterator<WorkerInfo> workerIt = availableWorkerInfos.iterator();
        for (int i = 0; i < partitionCount; ++i) {
            BasicPartitionOwner owner = new BasicPartitionOwner(i, workerIt.next());
            if (!workerIt.hasNext()) {
                workerIt = availableWorkerInfos.iterator();
            }
            ownerList.add(owner);
        }
        this.partitionOwnerList = ownerList;
        return ownerList;
    }

    @Override
    public void setPartitionOwners(Collection<PartitionOwner> partitionOwners) {
        this.partitionOwnerList = Lists.newArrayList(partitionOwners);
    }

    @Override
    public Collection<PartitionOwner> getCurrentPartitionOwners() {
        return this.partitionOwnerList;
    }

    protected void setPartitionOwnerList(List<PartitionOwner> partitionOwnerList) {
        this.partitionOwnerList = partitionOwnerList;
    }

    @Override
    public Collection<PartitionOwner> generateChangedPartitionOwners(Collection<PartitionStats> allPartitionStatsList, Collection<WorkerInfo> availableWorkerInfos, int maxWorkers, long superstep) {
        return PartitionBalancer.balancePartitionsAcrossWorkers(this.conf, this.partitionOwnerList, allPartitionStatsList, availableWorkerInfos);
    }

    @Override
    public PartitionStats createPartitionStats() {
        return new PartitionStats();
    }
}

