/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.partition.PartitionStore;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;

public class DiskBackedPartitionStore<I extends WritableComparable, V extends Writable, E extends Writable>
extends PartitionStore<I, V, E> {
    private static final Logger LOG = Logger.getLogger(DiskBackedPartitionStore.class);
    private final ConcurrentMap<Integer, MetaPartition> partitions = Maps.newConcurrentMap();
    private final Map<Integer, MetaPartition> lru = Maps.newLinkedHashMap();
    private final ImmutableClassesGiraphConfiguration<I, V, E> conf;
    private final Mapper.Context context;
    private final String[] basePaths;
    private final HashFunction hasher = Hashing.murmur3_32();
    private final int maxPartitionsInMem;
    private AtomicInteger numPartitionsInMem;
    private CentralizedServiceWorker<I, V, E> serviceWorker;
    private AtomicLong numOfStickyPartitions;
    private long passedThroughEdges;

    public DiskBackedPartitionStore(ImmutableClassesGiraphConfiguration<I, V, E> conf, Mapper.Context context, CentralizedServiceWorker<I, V, E> serviceWorker) {
        this.conf = conf;
        this.context = context;
        this.serviceWorker = serviceWorker;
        this.passedThroughEdges = 0L;
        this.numPartitionsInMem = new AtomicInteger(0);
        this.maxPartitionsInMem = Math.max(GiraphConstants.MAX_PARTITIONS_IN_MEMORY.get(conf), 1);
        int numInputThreads = GiraphConstants.NUM_INPUT_THREADS.get(conf);
        int numComputeThreads = GiraphConstants.NUM_COMPUTE_THREADS.get(conf);
        int numOutputThreads = GiraphConstants.NUM_OUTPUT_THREADS.get(conf);
        int maxThreads = Math.max(numInputThreads, Math.max(numComputeThreads, numOutputThreads));
        long maxSticky = GiraphConstants.MAX_STICKY_PARTITIONS.get(conf);
        if (maxSticky > 0L && (long)this.maxPartitionsInMem - maxSticky >= (long)maxThreads) {
            this.numOfStickyPartitions = new AtomicLong(maxSticky);
        } else {
            if ((long)this.maxPartitionsInMem - maxSticky >= (long)maxThreads && LOG.isInfoEnabled()) {
                LOG.info((Object)"giraph.maxSticky parameter unset or improperly set resetting to automatically computed value.");
            }
            this.numOfStickyPartitions = this.maxPartitionsInMem == 1 || maxThreads >= this.maxPartitionsInMem ? new AtomicLong(0L) : new AtomicLong(this.maxPartitionsInMem - maxThreads);
        }
        String[] userPaths = GiraphConstants.PARTITIONS_DIRECTORY.getArray(conf);
        this.basePaths = new String[userPaths.length];
        int i = 0;
        for (String path : userPaths) {
            this.basePaths[i++] = path + "/" + conf.get("mapred.job.id", "Unknown Job");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("DiskBackedPartitionStore with maxInMemoryPartitions=" + this.maxPartitionsInMem + ", isStaticGraph=" + conf.isStaticGraph()));
        }
    }

    @Override
    public Iterable<Integer> getPartitionIds() {
        return Iterables.unmodifiableIterable(this.partitions.keySet());
    }

    @Override
    public boolean hasPartition(Integer id) {
        return this.partitions.containsKey(id);
    }

    @Override
    public int getNumPartitions() {
        return this.partitions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partition<I, V, E> getOrCreatePartition(Integer id) {
        MetaPartition meta = new MetaPartition(id);
        MetaPartition temp = this.partitions.putIfAbsent(id, meta);
        if (temp != null) {
            meta = temp;
        }
        MetaPartition metaPartition = meta;
        synchronized (metaPartition) {
            if (temp == null && this.numOfStickyPartitions.getAndDecrement() > 0L) {
                meta.setSticky();
            }
            this.getPartition(meta);
            if (meta.getPartition() == null) {
                Partition<I, V, E> partition = this.conf.createPartition(id, (Progressable)this.context);
                meta.setPartition(partition);
                this.addPartition(meta, partition);
                if (meta.getState() == State.INIT) {
                    LOG.warn((Object)"Partition was still INIT after ADD (not possibile).");
                }
                this.getPartition(meta);
                if (meta.getState() == State.INIT) {
                    LOG.warn((Object)"Partition was still INIT after GET (not possibile).");
                }
            }
            if (meta.getState() == State.INIT) {
                String msg = "Getting a partition which is in INIT state is not allowed. " + meta;
                LOG.error((Object)msg);
                throw new IllegalStateException(msg);
            }
            return meta.getPartition();
        }
    }

    @Override
    public void putPartition(Partition<I, V, E> partition) {
        Integer id = partition.getId();
        MetaPartition meta = (MetaPartition)this.partitions.get(id);
        this.putPartition(meta);
    }

    @Override
    public void deletePartition(Integer id) {
        if (this.hasPartition(id)) {
            MetaPartition meta = (MetaPartition)this.partitions.get(id);
            this.deletePartition(meta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Partition<I, V, E> removePartition(Integer id) {
        if (this.hasPartition(id)) {
            MetaPartition meta;
            MetaPartition metaPartition = meta = (MetaPartition)this.partitions.get(id);
            synchronized (metaPartition) {
                this.getPartition(meta);
                this.putPartition(meta);
                this.deletePartition(id);
            }
            return meta.getPartition();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartition(Partition<I, V, E> partition) {
        Integer id = partition.getId();
        MetaPartition meta = new MetaPartition(id);
        meta.setPartition(partition);
        MetaPartition temp = this.partitions.putIfAbsent(id, meta);
        if (temp != null) {
            meta = temp;
        }
        MetaPartition metaPartition = meta;
        synchronized (metaPartition) {
            if (temp == null && this.numOfStickyPartitions.getAndDecrement() > 0L) {
                meta.setSticky();
            }
            this.addPartition(meta, partition);
        }
    }

    @Override
    public void shutdown() {
        for (MetaPartition e : this.partitions.values()) {
            if (e.getState() != State.ONDISK) continue;
            this.deletePartitionFiles(e.getId());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (MetaPartition e : this.partitions.values()) {
            sb.append(e.toString() + "\n");
        }
        return sb.toString();
    }

    private void writeVertexData(DataOutput output, Vertex<I, V, E> vertex) throws IOException {
        vertex.getId().write(output);
        vertex.getValue().write(output);
        output.writeBoolean(vertex.isHalted());
    }

    private void writeOutEdges(DataOutput output, Vertex<I, V, E> vertex) throws IOException {
        vertex.getId().write(output);
        OutEdges edges = (OutEdges)vertex.getEdges();
        edges.write(output);
    }

    private void readVertexData(DataInput in, Vertex<I, V, E> vertex) throws IOException {
        I id = this.conf.createVertexId();
        id.readFields(in);
        V value = this.conf.createVertexValue();
        value.readFields(in);
        OutEdges<I, E> edges = this.conf.createAndInitializeOutEdges(0);
        vertex.initialize(id, value, edges);
        if (in.readBoolean()) {
            vertex.voteToHalt();
        } else {
            vertex.wakeUp();
        }
    }

    private void readOutEdges(DataInput in, Partition<I, V, E> partition) throws IOException {
        I id = this.conf.createVertexId();
        id.readFields(in);
        Vertex<I, V, E> v = partition.getVertex(id);
        OutEdges edges = (OutEdges)v.getEdges();
        edges.readFields(in);
        partition.saveVertex(v);
    }

    private Partition<I, V, E> loadPartition(int id, long numVertices) throws IOException {
        Partition<I, V, E> partition = this.conf.createPartition(id, (Progressable)this.context);
        File file = new File(this.getVerticesPath(id));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("loadPartition: loading partition vertices " + partition.getId() + " from " + file.getAbsolutePath()));
        }
        FileInputStream filein = new FileInputStream(file);
        BufferedInputStream bufferin = new BufferedInputStream(filein);
        DataInputStream inputStream = new DataInputStream(bufferin);
        int i = 0;
        while ((long)i < numVertices) {
            Vertex<I, V, E> vertex = this.conf.createVertex();
            this.readVertexData(inputStream, vertex);
            partition.putVertex(vertex);
            ++i;
        }
        inputStream.close();
        if (!file.delete()) {
            String msg = "loadPartition: failed to delete " + file.getAbsolutePath();
            LOG.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        file = new File(this.getEdgesPath(id));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("loadPartition: loading partition edges " + partition.getId() + " from " + file.getAbsolutePath()));
        }
        filein = new FileInputStream(file);
        bufferin = new BufferedInputStream(filein);
        inputStream = new DataInputStream(bufferin);
        i = 0;
        while ((long)i < numVertices) {
            this.readOutEdges(inputStream, partition);
            ++i;
        }
        inputStream.close();
        if (!this.conf.isStaticGraph() && !file.delete()) {
            String msg = "loadPartition: failed to delete " + file.getAbsolutePath();
            LOG.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        return partition;
    }

    private void offloadPartition(MetaPartition meta) throws IOException {
        Partition partition = meta.getPartition();
        File file = new File(this.getVerticesPath(partition.getId()));
        File parent = file.getParentFile();
        if (!parent.exists() && !parent.mkdirs() && LOG.isDebugEnabled()) {
            LOG.debug((Object)("offloadPartition: directory " + parent.getAbsolutePath() + " already exists."));
        }
        if (!file.createNewFile()) {
            String msg = "offloadPartition: file " + parent.getAbsolutePath() + " already exists.";
            LOG.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("offloadPartition: writing partition vertices " + partition.getId() + " to " + file.getAbsolutePath()));
        }
        FileOutputStream fileout = new FileOutputStream(file);
        BufferedOutputStream bufferout = new BufferedOutputStream(fileout);
        DataOutputStream outputStream = new DataOutputStream(bufferout);
        for (Vertex vertex : partition) {
            this.writeVertexData(outputStream, vertex);
        }
        outputStream.close();
        file = new File(this.getEdgesPath(partition.getId()));
        if (meta.getPrevVertexCount() != partition.getVertexCount() || !this.conf.isStaticGraph() || !file.exists()) {
            meta.setPrevVertexCount(partition.getVertexCount());
            if (!file.createNewFile() && LOG.isDebugEnabled()) {
                LOG.debug((Object)("offloadPartition: file " + file.getAbsolutePath() + " already exists."));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("offloadPartition: writing partition edges " + partition.getId() + " to " + file.getAbsolutePath()));
            }
            fileout = new FileOutputStream(file);
            bufferout = new BufferedOutputStream(fileout);
            outputStream = new DataOutputStream(bufferout);
            for (Vertex vertex : partition) {
                this.writeOutEdges(outputStream, vertex);
            }
            outputStream.close();
        }
    }

    private void addToOOCPartition(MetaPartition meta, Partition<I, V, E> partition) throws IOException {
        Integer id = partition.getId();
        File file = new File(this.getVerticesPath(id));
        DataOutputStream outputStream = null;
        FileOutputStream fileout = new FileOutputStream(file, true);
        BufferedOutputStream bufferout = new BufferedOutputStream(fileout);
        outputStream = new DataOutputStream(bufferout);
        for (Vertex vertex : partition) {
            this.writeVertexData(outputStream, vertex);
        }
        outputStream.close();
        file = new File(this.getEdgesPath(id));
        fileout = new FileOutputStream(file, true);
        bufferout = new BufferedOutputStream(fileout);
        outputStream = new DataOutputStream(bufferout);
        for (Vertex vertex : partition) {
            this.writeOutEdges(outputStream, vertex);
        }
        outputStream.close();
    }

    public void deletePartitionFiles(Integer id) {
        File file = new File(this.getVerticesPath(id));
        if (file.exists() && !file.delete()) {
            String msg = "deletePartitionFiles: Failed to delete file " + file.getAbsolutePath();
            LOG.error((Object)msg);
            throw new IllegalStateException(msg);
        }
        file = new File(this.getEdgesPath(id));
        if (file.exists() && !file.delete()) {
            String msg = "deletePartitionFiles: Failed to delete file " + file.getAbsolutePath();
            LOG.error((Object)msg);
            throw new IllegalStateException(msg);
        }
    }

    private String getPartitionPath(Integer partitionId) {
        int hash = this.hasher.hashInt(partitionId.intValue()).asInt();
        int idx = Math.abs(hash % this.basePaths.length);
        return this.basePaths[idx] + "/partition-" + partitionId;
    }

    private String getVerticesPath(Integer partitionId) {
        return this.getPartitionPath(partitionId) + "_vertices";
    }

    private String getEdgesPath(Integer partitionId) {
        return this.getPartitionPath(partitionId) + "_edges";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaPartition getLRUPartition() {
        Map<Integer, MetaPartition> map = this.lru;
        synchronized (map) {
            Iterator<Map.Entry<Integer, MetaPartition>> i = this.lru.entrySet().iterator();
            Map.Entry<Integer, MetaPartition> entry = i.next();
            i.remove();
            return entry.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"TLW_TWO_LOCK_WAIT"}, justification="The two locks held do not produce a deadlock")
    private void getPartition(MetaPartition meta) {
        MetaPartition metaPartition = meta;
        synchronized (metaPartition) {
            boolean isNotDone = true;
            if (meta.getState() != State.INIT) {
                block25: while (isNotDone) {
                    State state = meta.getState();
                    switch (state) {
                        case ONDISK: {
                            Partition<I, V, E> partition;
                            Object p;
                            String msg;
                            MetaPartition swapOutPartition = null;
                            long numVertices = meta.getVertexCount();
                            Object object = this.lru;
                            synchronized (object) {
                                try {
                                    while (this.numPartitionsInMem.get() >= this.maxPartitionsInMem && this.lru.isEmpty()) {
                                        this.lru.wait();
                                    }
                                }
                                catch (InterruptedException e) {
                                    LOG.error((Object)("getPartition: error while waiting on LRU data structure: " + e.getMessage()));
                                    throw new IllegalStateException(e);
                                }
                                if (this.numPartitionsInMem.get() >= this.maxPartitionsInMem && !this.lru.isEmpty()) {
                                    swapOutPartition = this.getLRUPartition();
                                } else if (this.numPartitionsInMem.get() < this.maxPartitionsInMem) {
                                    this.numPartitionsInMem.getAndIncrement();
                                } else {
                                    msg = "lru is empty and there is not space in memory, hence the partition cannot be loaded.";
                                    LOG.error((Object)msg);
                                    throw new IllegalStateException(msg);
                                }
                            }
                            if (swapOutPartition != null) {
                                object = swapOutPartition;
                                synchronized (object) {
                                    if (swapOutPartition.isSticky()) {
                                        msg = "Partition " + meta.getId() + " is sticky " + " and cannot be offloaded.";
                                        LOG.error((Object)msg);
                                        throw new IllegalStateException(msg);
                                    }
                                    if (swapOutPartition.getState() != State.INACTIVE) {
                                        msg = "Someone is holding the partition with id " + swapOutPartition.getId() + " but is supposed to be " + "inactive.";
                                        LOG.error((Object)msg);
                                        throw new IllegalStateException(msg);
                                    }
                                    try {
                                        this.offloadPartition(swapOutPartition);
                                        p = swapOutPartition.getPartition();
                                        swapOutPartition.setOnDisk(p);
                                        swapOutPartition.notifyAll();
                                    }
                                    catch (IOException e) {
                                        LOG.error((Object)("getPartition: Failed while Offloading New Partition: " + e.getMessage()));
                                        throw new IllegalStateException(e);
                                    }
                                }
                            }
                            try {
                                partition = this.loadPartition(meta.getId(), numVertices);
                            }
                            catch (IOException e) {
                                LOG.error((Object)("getPartition: Failed while Loading Partition from disk: " + e.getMessage()));
                                throw new IllegalStateException(e);
                            }
                            meta.setActive(partition);
                            isNotDone = false;
                            continue block25;
                        }
                        case INACTIVE: {
                            Object p = null;
                            if (meta.isSticky()) {
                                meta.setActive();
                                isNotDone = false;
                                continue block25;
                            }
                            Map<Integer, MetaPartition> map = this.lru;
                            synchronized (map) {
                                p = this.lru.remove(meta.getId());
                            }
                            if (p == meta && ((MetaPartition)p).getState() == State.INACTIVE) {
                                meta.setActive();
                                isNotDone = false;
                                continue block25;
                            }
                            try {
                                meta.wait();
                            }
                            catch (InterruptedException e) {
                                LOG.error((Object)("getPartition: error while waiting on previously Inactive Partition: " + e.getMessage()));
                                throw new IllegalStateException(e);
                            }
                            isNotDone = true;
                            continue block25;
                        }
                        case ACTIVE: {
                            meta.incrementReferences();
                            isNotDone = false;
                            continue block25;
                        }
                    }
                    throw new IllegalStateException("illegal state " + (Object)((Object)meta.getState()) + " for partition " + meta.getId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putPartition(MetaPartition meta) {
        MetaPartition metaPartition = meta;
        synchronized (metaPartition) {
            if (meta.getState() != State.ACTIVE) {
                String msg = "It is not possible to put back a partition which is not ACTIVE.\n" + meta.toString();
                LOG.error((Object)msg);
                throw new IllegalStateException(msg);
            }
            if (meta.decrementReferences() == 0) {
                meta.setState(State.INACTIVE);
                if (!meta.isSticky()) {
                    Map<Integer, MetaPartition> map = this.lru;
                    synchronized (map) {
                        this.lru.put(meta.getId(), meta);
                        this.lru.notifyAll();
                    }
                }
                meta.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPartition(MetaPartition meta, Partition<I, V, E> partition) {
        MetaPartition metaPartition = meta;
        synchronized (metaPartition) {
            if (meta.getState() == State.INIT) {
                if (partition == null) {
                    String msg = "No partition was provided.";
                    LOG.error((Object)msg);
                    throw new IllegalStateException(msg);
                }
                if (partition != meta.getPartition()) {
                    String msg = "Partition and Meta-Partition should contain the same data";
                    LOG.error((Object)msg);
                    throw new IllegalStateException(msg);
                }
                Map<Integer, MetaPartition> msg = this.lru;
                synchronized (msg) {
                    if (this.numPartitionsInMem.get() < this.maxPartitionsInMem || meta.isSticky) {
                        meta.setState(State.INACTIVE);
                        this.numPartitionsInMem.getAndIncrement();
                        if (!meta.isSticky) {
                            this.lru.put(meta.getId(), meta);
                            this.lru.notifyAll();
                        }
                        return;
                    }
                }
                try {
                    this.offloadPartition(meta);
                    meta.setOnDisk(partition);
                }
                catch (IOException e) {
                    LOG.error((Object)("addPartition: Failed while Offloading New Partition: " + e.getMessage()));
                    throw new IllegalStateException(e);
                }
            }
            Partition<I, V, E> existing = null;
            boolean isOOC = false;
            boolean isNotDone = true;
            block20: while (isNotDone) {
                State state = meta.getState();
                switch (state) {
                    case ONDISK: {
                        isOOC = true;
                        isNotDone = false;
                        meta.addToVertexCount(partition.getVertexCount());
                        continue block20;
                    }
                    case INACTIVE: {
                        MetaPartition p = null;
                        if (meta.isSticky()) {
                            existing = meta.getPartition();
                            isNotDone = false;
                            continue block20;
                        }
                        Map<Integer, MetaPartition> map = this.lru;
                        synchronized (map) {
                            p = this.lru.get(meta.getId());
                        }
                        if (p == meta) {
                            existing = meta.getPartition();
                            isNotDone = false;
                            continue block20;
                        }
                        try {
                            meta.wait();
                        }
                        catch (InterruptedException e) {
                            LOG.error((Object)("addPartition: error while waiting on previously inactive partition: " + e.getMessage()));
                            throw new IllegalStateException(e);
                        }
                        isNotDone = true;
                        continue block20;
                    }
                    case ACTIVE: {
                        existing = meta.getPartition();
                        isNotDone = false;
                        continue block20;
                    }
                }
                throw new IllegalStateException("illegal state " + (Object)((Object)state) + " for partition " + meta.getId());
            }
            if (isOOC) {
                try {
                    this.addToOOCPartition(meta, partition);
                }
                catch (IOException e) {
                    LOG.error((Object)("addPartition: Failed while Adding to OOC Partition: " + e.getMessage()));
                    throw new IllegalStateException(e);
                }
            } else {
                existing.addPartition(partition);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePartition(MetaPartition meta) {
        MetaPartition metaPartition = meta;
        synchronized (metaPartition) {
            boolean isDone = false;
            int id = meta.getId();
            block15: while (!isDone) {
                State state = meta.getState();
                switch (state) {
                    case ONDISK: {
                        this.deletePartitionFiles(id);
                        isDone = true;
                        continue block15;
                    }
                    case INACTIVE: {
                        if (meta.isSticky()) {
                            isDone = true;
                            this.numPartitionsInMem.getAndDecrement();
                            continue block15;
                        }
                        Map<Integer, MetaPartition> map = this.lru;
                        synchronized (map) {
                            MetaPartition p = this.lru.remove(id);
                            if (p == meta && p.getState() == State.INACTIVE) {
                                isDone = true;
                                this.numPartitionsInMem.getAndDecrement();
                                this.lru.notifyAll();
                                continue block15;
                            }
                        }
                        try {
                            meta.wait();
                        }
                        catch (InterruptedException e) {
                            LOG.error((Object)("deletePartition: error while waiting on previously inactive partition: " + e.getMessage()));
                            throw new IllegalStateException(e);
                        }
                        isDone = false;
                        continue block15;
                    }
                    case ACTIVE: {
                        try {
                            meta.wait();
                            continue block15;
                        }
                        catch (InterruptedException e) {
                            LOG.error((Object)("deletePartition: error while waiting on active partition: " + e.getMessage()));
                            throw new IllegalStateException(e);
                        }
                    }
                }
                throw new IllegalStateException("illegal state " + (Object)((Object)state) + " for partition " + id);
            }
            this.partitions.remove(id);
        }
    }

    private class MetaPartition {
        private int id;
        private State state;
        private int references;
        private long vertexCount;
        private long prevVertexCount;
        private boolean isSticky;
        private Partition<I, V, E> partition;

        public MetaPartition(int id) {
            this.id = id;
            this.state = State.INIT;
            this.references = 0;
            this.vertexCount = 0L;
            this.prevVertexCount = 0L;
            this.isSticky = false;
            this.partition = null;
        }

        public int getId() {
            return this.id;
        }

        public State getState() {
            return this.state;
        }

        public void setOnDisk(Partition<I, V, E> partition) {
            this.state = State.ONDISK;
            this.partition = null;
            this.vertexCount = partition.getVertexCount();
        }

        public void setActive() {
            this.setActive(null);
        }

        public void setActive(Partition<I, V, E> partition) {
            if (partition != null) {
                this.partition = partition;
            }
            this.state = State.ACTIVE;
            this.prevVertexCount = this.vertexCount;
            this.vertexCount = 0L;
            this.incrementReferences();
        }

        public void setState(State state) {
            this.state = state;
        }

        public int decrementReferences() {
            if (this.references > 0) {
                --this.references;
            }
            return this.references;
        }

        public int incrementReferences() {
            return ++this.references;
        }

        public void setPrevVertexCount(long vertexCount) {
            this.prevVertexCount = vertexCount;
        }

        public long getPrevVertexCount() {
            return this.prevVertexCount;
        }

        public long getVertexCount() {
            return this.vertexCount;
        }

        public void addToVertexCount(long inc) {
            this.vertexCount += inc;
            this.prevVertexCount = this.vertexCount;
        }

        public Partition<I, V, E> getPartition() {
            return this.partition;
        }

        public void setPartition(Partition<I, V, E> partition) {
            this.partition = partition;
        }

        public void setSticky() {
            this.isSticky = true;
        }

        public boolean isSticky() {
            return this.isSticky;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Meta Data: { ");
            sb.append("ID: " + this.id + "; ");
            sb.append("State: " + (Object)((Object)this.state) + "; ");
            sb.append("Number of References: " + this.references + "; ");
            sb.append("Number of Vertices: " + this.vertexCount + "; ");
            sb.append("Previous number of Vertices: " + this.prevVertexCount + "; ");
            sb.append("Is Sticky: " + this.isSticky + "; ");
            sb.append("Partition: " + this.partition + "; }");
            return sb.toString();
        }
    }

    private static enum State {
        INIT,
        ACTIVE,
        INACTIVE,
        ONDISK;

    }
}

