/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import com.google.common.collect.MapMaker;
import com.google.common.primitives.Ints;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.partition.BasicPartition;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.partition.ReusesObjectsPartition;
import org.apache.giraph.utils.UnsafeByteArrayInputStream;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.Progressable;

@NotThreadSafe
public class ByteArrayPartition<I extends WritableComparable, V extends Writable, E extends Writable>
extends BasicPartition<I, V, E>
implements ReusesObjectsPartition<I, V, E> {
    private ConcurrentMap<I, byte[]> vertexMap;
    private Vertex<I, V, E> representativeVertex;
    private Vertex<I, V, E> representativeCombinerVertex;
    private boolean useUnsafeSerialization;

    @Override
    public void initialize(int partitionId, Progressable progressable) {
        super.initialize(partitionId, progressable);
        this.vertexMap = new MapMaker().concurrencyLevel(this.getConf().getNettyServerExecutionConcurrency()).makeMap();
        this.representativeVertex = this.getConf().createVertex();
        this.representativeVertex.initialize(this.getConf().createVertexId(), this.getConf().createVertexValue(), this.getConf().createOutEdges());
        this.representativeCombinerVertex = this.getConf().createVertex();
        this.representativeCombinerVertex.initialize(this.getConf().createVertexId(), this.getConf().createVertexValue(), this.getConf().createOutEdges());
        this.useUnsafeSerialization = this.getConf().useUnsafeSerialization();
    }

    @Override
    public Vertex<I, V, E> getVertex(I vertexIndex) {
        byte[] vertexData = (byte[])this.vertexMap.get(vertexIndex);
        if (vertexData == null) {
            return null;
        }
        WritableUtils.reinitializeVertexFromByteArray(vertexData, this.representativeVertex, this.useUnsafeSerialization, this.getConf());
        return this.representativeVertex;
    }

    @Override
    public Vertex<I, V, E> putVertex(Vertex<I, V, E> vertex) {
        byte[] vertexData = WritableUtils.writeVertexToByteArray(vertex, this.useUnsafeSerialization, this.getConf());
        byte[] oldVertexBytes = this.vertexMap.put(vertex.getId(), vertexData);
        if (oldVertexBytes == null) {
            return null;
        }
        WritableUtils.reinitializeVertexFromByteArray(oldVertexBytes, this.representativeVertex, this.useUnsafeSerialization, this.getConf());
        return this.representativeVertex;
    }

    @Override
    public Vertex<I, V, E> removeVertex(I vertexIndex) {
        byte[] vertexBytes = (byte[])this.vertexMap.remove(vertexIndex);
        if (vertexBytes == null) {
            return null;
        }
        WritableUtils.reinitializeVertexFromByteArray(vertexBytes, this.representativeVertex, this.useUnsafeSerialization, this.getConf());
        return this.representativeVertex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPartition(Partition<I, V, E> partition) {
        if (!(partition instanceof ByteArrayPartition)) {
            throw new IllegalStateException("addPartition: Cannot add partition of type " + partition.getClass());
        }
        ByteArrayPartition byteArrayPartition = (ByteArrayPartition)partition;
        for (Map.Entry entry : byteArrayPartition.vertexMap.entrySet()) {
            byte[] oldVertexBytes = this.vertexMap.putIfAbsent((I)entry.getKey(), (byte[])entry.getValue());
            if (oldVertexBytes == null) continue;
            ByteArrayPartition byteArrayPartition2 = this;
            synchronized (byteArrayPartition2) {
                WritableUtils.reinitializeVertexFromByteArray(oldVertexBytes, this.representativeVertex, this.useUnsafeSerialization, this.getConf());
                WritableUtils.reinitializeVertexFromByteArray((byte[])entry.getValue(), this.representativeCombinerVertex, this.useUnsafeSerialization, this.getConf());
                this.combine(this.representativeVertex, this.representativeCombinerVertex);
            }
        }
    }

    @Override
    public synchronized boolean putOrCombine(Vertex<I, V, E> vertex) {
        byte[] vertexData = WritableUtils.writeVertexToByteArray(vertex, this.useUnsafeSerialization, this.getConf());
        byte[] oldVertexBytes = this.vertexMap.putIfAbsent(vertex.getId(), vertexData);
        if (oldVertexBytes == null) {
            return true;
        }
        WritableUtils.reinitializeVertexFromByteArray(oldVertexBytes, this.representativeVertex, this.useUnsafeSerialization, this.getConf());
        this.combine(this.representativeVertex, vertex);
        return false;
    }

    private void combine(Vertex<I, V, E> representativeVertex, Vertex<I, V, E> representativeCombinerVertex) {
        this.getVertexValueCombiner().combine(representativeVertex.getValue(), representativeCombinerVertex.getValue());
        for (Edge<I, E> edge : representativeCombinerVertex.getEdges()) {
            representativeVertex.addEdge(edge);
        }
        this.vertexMap.put(representativeCombinerVertex.getId(), WritableUtils.writeVertexToByteArray(representativeVertex, this.useUnsafeSerialization, this.getConf()));
    }

    @Override
    public long getVertexCount() {
        return this.vertexMap.size();
    }

    @Override
    public long getEdgeCount() {
        long edges = 0L;
        for (byte[] vertexBytes : this.vertexMap.values()) {
            WritableUtils.reinitializeVertexFromByteArray(vertexBytes, this.representativeVertex, this.useUnsafeSerialization, this.getConf());
            edges += (long)this.representativeVertex.getNumEdges();
        }
        return edges;
    }

    @Override
    public void saveVertex(Vertex<I, V, E> vertex) {
        byte[] oldVertexData = (byte[])this.vertexMap.get(vertex.getId());
        if (oldVertexData != null) {
            this.vertexMap.put(vertex.getId(), WritableUtils.writeVertexToByteArray(vertex, oldVertexData, this.useUnsafeSerialization, this.getConf()));
        } else {
            this.vertexMap.put(vertex.getId(), WritableUtils.writeVertexToByteArray(vertex, this.useUnsafeSerialization, this.getConf()));
        }
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        output.writeInt(this.vertexMap.size());
        for (Map.Entry entry : this.vertexMap.entrySet()) {
            this.progress();
            ((WritableComparable)entry.getKey()).write(output);
            int vertexDataSize = this.useUnsafeSerialization ? UnsafeByteArrayInputStream.getInt((byte[])entry.getValue(), 0) : Ints.fromByteArray((byte[])((byte[])entry.getValue()));
            output.writeInt(vertexDataSize);
            output.write((byte[])entry.getValue(), 0, vertexDataSize);
        }
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        super.readFields(input);
        int size = input.readInt();
        this.vertexMap = new MapMaker().concurrencyLevel(this.getConf().getNettyServerExecutionConcurrency()).initialCapacity(size).makeMap();
        this.representativeVertex = this.getConf().createVertex();
        this.representativeVertex.initialize(this.getConf().createVertexId(), this.getConf().createVertexValue(), this.getConf().createOutEdges());
        this.useUnsafeSerialization = this.getConf().useUnsafeSerialization();
        for (int i = 0; i < size; ++i) {
            this.progress();
            Object vertexId = this.getConf().createVertexId();
            vertexId.readFields(input);
            int vertexDataSize = input.readInt();
            byte[] vertexData = new byte[vertexDataSize];
            input.readFully(vertexData);
            if (this.vertexMap.put(vertexId, vertexData) == null) continue;
            throw new IllegalStateException("readFields: Already saw vertex " + vertexId);
        }
    }

    @Override
    public Iterator<Vertex<I, V, E>> iterator() {
        return new RepresentativeVertexIterator();
    }

    private class RepresentativeVertexIterator
    implements Iterator<Vertex<I, V, E>> {
        private Iterator<byte[]> vertexDataIterator;

        private RepresentativeVertexIterator() {
            this.vertexDataIterator = ByteArrayPartition.this.vertexMap.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.vertexDataIterator.hasNext();
        }

        @Override
        public Vertex<I, V, E> next() {
            WritableUtils.reinitializeVertexFromByteArray(this.vertexDataIterator.next(), ByteArrayPartition.this.representativeVertex, ByteArrayPartition.this.useUnsafeSerialization, ByteArrayPartition.this.getConf());
            return ByteArrayPartition.this.representativeVertex;
        }

        @Override
        public void remove() {
            throw new IllegalAccessError("remove: This method is not supported.");
        }
    }
}

