/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.giraph.conf.ImmutableClassesGiraphConfigurable;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.worker.WorkerInfo;

public class BasicPartitionOwner
implements PartitionOwner,
ImmutableClassesGiraphConfigurable {
    private ImmutableClassesGiraphConfiguration conf;
    private int partitionId = -1;
    private WorkerInfo workerInfo;
    private WorkerInfo previousWorkerInfo;
    private String checkpointFilesPrefix;

    public BasicPartitionOwner() {
    }

    public BasicPartitionOwner(int partitionId, WorkerInfo workerInfo) {
        this(partitionId, workerInfo, null, null);
    }

    public BasicPartitionOwner(int partitionId, WorkerInfo workerInfo, WorkerInfo previousWorkerInfo, String checkpointFilesPrefix) {
        this.partitionId = partitionId;
        this.workerInfo = workerInfo;
        this.previousWorkerInfo = previousWorkerInfo;
        this.checkpointFilesPrefix = checkpointFilesPrefix;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public WorkerInfo getWorkerInfo() {
        return this.workerInfo;
    }

    @Override
    public void setWorkerInfo(WorkerInfo workerInfo) {
        this.workerInfo = workerInfo;
    }

    @Override
    public WorkerInfo getPreviousWorkerInfo() {
        return this.previousWorkerInfo;
    }

    @Override
    public void setPreviousWorkerInfo(WorkerInfo workerInfo) {
        this.previousWorkerInfo = workerInfo;
    }

    @Override
    public void writeWithWorkerIds(DataOutput output) throws IOException {
        output.writeInt(this.partitionId);
        output.writeInt(this.workerInfo.getTaskId());
        if (this.previousWorkerInfo != null) {
            output.writeInt(this.previousWorkerInfo.getTaskId());
        } else {
            output.writeInt(-1);
        }
        if (this.checkpointFilesPrefix != null) {
            output.writeBoolean(true);
            output.writeUTF(this.checkpointFilesPrefix);
        } else {
            output.writeBoolean(false);
        }
    }

    @Override
    public void readFieldsWithWorkerIds(DataInput input, Map<Integer, WorkerInfo> workerInfoMap) throws IOException {
        boolean hasCheckpointFilePrefix;
        this.partitionId = input.readInt();
        int workerId = input.readInt();
        this.workerInfo = workerInfoMap.get(workerId);
        int previousWorkerId = input.readInt();
        if (previousWorkerId != -1) {
            this.previousWorkerInfo = workerInfoMap.get(previousWorkerId);
        }
        if (hasCheckpointFilePrefix = input.readBoolean()) {
            this.checkpointFilesPrefix = input.readUTF();
        }
    }

    public void readFields(DataInput input) throws IOException {
        boolean hasCheckpointFilePrefix;
        this.partitionId = input.readInt();
        this.workerInfo = new WorkerInfo();
        this.workerInfo.readFields(input);
        boolean hasPreviousWorkerInfo = input.readBoolean();
        if (hasPreviousWorkerInfo) {
            this.previousWorkerInfo = new WorkerInfo();
            this.previousWorkerInfo.readFields(input);
        }
        if (hasCheckpointFilePrefix = input.readBoolean()) {
            this.checkpointFilesPrefix = input.readUTF();
        }
    }

    public void write(DataOutput output) throws IOException {
        output.writeInt(this.partitionId);
        this.workerInfo.write(output);
        if (this.previousWorkerInfo != null) {
            output.writeBoolean(true);
            this.previousWorkerInfo.write(output);
        } else {
            output.writeBoolean(false);
        }
        if (this.checkpointFilesPrefix != null) {
            output.writeBoolean(true);
            output.writeUTF(this.checkpointFilesPrefix);
        } else {
            output.writeBoolean(false);
        }
    }

    public ImmutableClassesGiraphConfiguration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(ImmutableClassesGiraphConfiguration conf) {
        this.conf = conf;
    }

    public String toString() {
        return "(id=" + this.partitionId + ",cur=" + this.workerInfo + ",prev=" + this.previousWorkerInfo + ",ckpt_file=" + this.checkpointFilesPrefix + ")";
    }
}

