/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.partition;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.VertexValueCombiner;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.utils.VertexIterator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.Progressable;

public abstract class BasicPartition<I extends WritableComparable, V extends Writable, E extends Writable>
implements Partition<I, V, E> {
    private ImmutableClassesGiraphConfiguration<I, V, E> conf;
    private int id;
    private Progressable progressable;
    private VertexValueCombiner<V> vertexValueCombiner;

    @Override
    public void initialize(int partitionId, Progressable progressable) {
        this.setId(partitionId);
        this.setProgressable(progressable);
        this.vertexValueCombiner = this.conf.createVertexValueCombiner();
    }

    @Override
    public void setConf(ImmutableClassesGiraphConfiguration<I, V, E> configuration) {
        this.conf = configuration;
    }

    @Override
    public ImmutableClassesGiraphConfiguration<I, V, E> getConf() {
        return this.conf;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public void progress() {
        if (this.progressable != null) {
            this.progressable.progress();
        }
    }

    @Override
    public void setProgressable(Progressable progressable) {
        this.progressable = progressable;
    }

    public VertexValueCombiner<V> getVertexValueCombiner() {
        return this.vertexValueCombiner;
    }

    @Override
    public void addPartitionVertices(VertexIterator<I, V, E> vertexIterator) {
        while (vertexIterator.hasNext()) {
            vertexIterator.next();
            if (!this.putOrCombine(vertexIterator.getVertex())) continue;
            vertexIterator.releaseVertex();
        }
    }

    public void write(DataOutput output) throws IOException {
        output.writeInt(this.id);
    }

    public void readFields(DataInput input) throws IOException {
        this.id = input.readInt();
    }
}

