/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.metrics;

import com.yammer.metrics.core.Gauge;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.giraph.metrics.GiraphMetrics;
import org.apache.giraph.metrics.GiraphTimer;
import org.apache.giraph.metrics.LongAndTimeUnit;
import org.apache.hadoop.io.Writable;

public class WorkerSuperstepMetrics
implements Writable {
    private LongAndTimeUnit commTimer = new LongAndTimeUnit();
    private LongAndTimeUnit computeAllTimer = new LongAndTimeUnit();
    private LongAndTimeUnit timeToFirstMsg = new LongAndTimeUnit();
    private LongAndTimeUnit superstepTimer = new LongAndTimeUnit();
    private LongAndTimeUnit waitRequestsTimer = new LongAndTimeUnit();

    public WorkerSuperstepMetrics readFromRegistry() {
        this.readGiraphTimer("communication-time-ms", this.commTimer);
        this.readGiraphTimer("compute-all-ms", this.computeAllTimer);
        this.readGiraphTimer("time-to-first-message-ms", this.timeToFirstMsg);
        this.readGiraphTimer("superstep-time-ms", this.superstepTimer);
        this.readGiraphTimer("wait-requests-us", this.waitRequestsTimer);
        return this;
    }

    private void readGiraphTimer(String name, LongAndTimeUnit data) {
        Gauge gauge = GiraphMetrics.get().perSuperstep().getExistingGauge(name);
        if (gauge instanceof GiraphTimer) {
            GiraphTimer giraphTimer = (GiraphTimer)gauge;
            data.setTimeUnit(giraphTimer.getTimeUnit());
            data.setValue((Long)giraphTimer.value());
        } else if (gauge != null) {
            throw new IllegalStateException(name + " is not a GiraphTimer");
        }
    }

    public WorkerSuperstepMetrics print(long superstep, PrintStream out) {
        out.println();
        out.println("--- METRICS: superstep " + superstep + " ---");
        out.println("  superstep time: " + this.superstepTimer);
        out.println("  compute all partitions: " + this.computeAllTimer);
        out.println("  network communication time: " + this.commTimer);
        out.println("  time to first message: " + this.timeToFirstMsg);
        out.println("  wait on requests time: " + this.waitRequestsTimer);
        return this;
    }

    public long getCommTimer() {
        return this.commTimer.getValue();
    }

    public long getComputeAllTimer() {
        return this.computeAllTimer.getValue();
    }

    public long getTimeToFirstMsg() {
        return this.timeToFirstMsg.getValue();
    }

    public long getSuperstepTimer() {
        return this.superstepTimer.getValue();
    }

    public long getWaitRequestsTimer() {
        return this.waitRequestsTimer.getValue();
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.commTimer.setValue(dataInput.readLong());
        this.computeAllTimer.setValue(dataInput.readLong());
        this.timeToFirstMsg.setValue(dataInput.readLong());
        this.superstepTimer.setValue(dataInput.readLong());
        this.waitRequestsTimer.setValue(dataInput.readLong());
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.commTimer.getValue());
        dataOutput.writeLong(this.computeAllTimer.getValue());
        dataOutput.writeLong(this.timeToFirstMsg.getValue());
        dataOutput.writeLong(this.superstepTimer.getValue());
        dataOutput.writeLong(this.waitRequestsTimer.getValue());
    }
}

