/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.metrics;

import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.reporting.ConsoleReporter;
import com.yammer.metrics.reporting.JmxReporter;
import java.io.PrintStream;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.metrics.GiraphMetricsRegistry;
import org.apache.giraph.metrics.NoOpMetricsRegistry;
import org.apache.giraph.metrics.WorkerSuperstepMetrics;

public class SuperstepMetricsRegistry
extends GiraphMetricsRegistry {
    private long superstep = -1L;

    protected SuperstepMetricsRegistry(MetricsRegistry registry, JmxReporter reporter, String groupName, String type) {
        super(registry, reporter, groupName, type);
    }

    public static SuperstepMetricsRegistry create(GiraphConfiguration conf, long superstep) {
        if (conf.metricsEnabled()) {
            MetricsRegistry registry = new MetricsRegistry();
            SuperstepMetricsRegistry superstepMetrics = new SuperstepMetricsRegistry(registry, new JmxReporter(registry), "giraph.superstep", String.valueOf(superstep));
            superstepMetrics.superstep = superstep;
            return superstepMetrics;
        }
        return SuperstepMetricsRegistry.createFake();
    }

    public static SuperstepMetricsRegistry createFake() {
        return new SuperstepMetricsRegistry(new NoOpMetricsRegistry(), null, "", "");
    }

    public long getSuperstep() {
        return this.superstep;
    }

    public void setSuperstep(long superstep) {
        super.setType(String.valueOf(superstep));
        this.superstep = superstep;
    }

    public void printSummary(PrintStream out) {
        new WorkerSuperstepMetrics().readFromRegistry().print(this.superstep, out);
        out.println("");
        MetricPredicate superstepFilter = new MetricPredicate(){

            public boolean matches(MetricName name, Metric metric) {
                return name.getType().equals(SuperstepMetricsRegistry.this.getType());
            }
        };
        new ConsoleReporter(this.getInternalRegistry(), out, superstepFilter).run();
    }
}

