/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.metrics;

import com.google.common.collect.ImmutableMap;
import java.util.concurrent.TimeUnit;
import org.apache.giraph.metrics.GiraphMetricsRegistry;
import org.apache.giraph.metrics.GiraphTimerContext;
import org.apache.giraph.metrics.ValueGauge;

public class GiraphTimer
extends ValueGauge<Long> {
    private static final ImmutableMap<TimeUnit, String> TIME_UNIT_TO_ABBREV = ImmutableMap.builder().put((Object)TimeUnit.DAYS, (Object)"days").put((Object)TimeUnit.HOURS, (Object)"hours").put((Object)TimeUnit.MICROSECONDS, (Object)"us").put((Object)TimeUnit.MILLISECONDS, (Object)"ms").put((Object)TimeUnit.MINUTES, (Object)"mins").put((Object)TimeUnit.NANOSECONDS, (Object)"ns").put((Object)TimeUnit.SECONDS, (Object)"secs").build();
    private TimeUnit timeUnit;

    public GiraphTimer(GiraphMetricsRegistry registry, String name, TimeUnit timeUnit) {
        super(registry, name);
        this.timeUnit = timeUnit;
        this.set(0L);
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public GiraphTimerContext time() {
        return new GiraphTimerContext(this);
    }

    public GiraphTimer set(long value, TimeUnit valueTimeUnit) {
        this.set(this.timeUnit.convert(value, valueTimeUnit));
        return this;
    }

    public String getTimeUnitAbbrev() {
        return (String)TIME_UNIT_TO_ABBREV.get((Object)this.timeUnit);
    }

    public String valueAndUnit() {
        return "" + this.value() + " " + this.getTimeUnitAbbrev();
    }
}

