/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.metrics;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.reporting.ConsoleReporter;
import com.yammer.metrics.reporting.JmxReporter;
import java.io.PrintStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.metrics.MeterDesc;
import org.apache.giraph.metrics.NoOpMetricsRegistry;

public class GiraphMetricsRegistry {
    private String groupName;
    private String type;
    private final MetricsRegistry registry;
    private final JmxReporter jmxReporter;

    protected GiraphMetricsRegistry(MetricsRegistry registry, JmxReporter reporter, String groupName, String type) {
        this.registry = registry;
        this.jmxReporter = reporter;
        this.groupName = groupName;
        this.type = type;
        if (this.jmxReporter != null) {
            this.jmxReporter.start();
        }
    }

    public static GiraphMetricsRegistry createFake() {
        return new GiraphMetricsRegistry(new NoOpMetricsRegistry(), null, "", "");
    }

    public static GiraphMetricsRegistry createWithOptional(String groupName, String type) {
        MetricsRegistry registry = new MetricsRegistry();
        return new GiraphMetricsRegistry(registry, new JmxReporter(registry), groupName, type);
    }

    public static GiraphMetricsRegistry create(GiraphConfiguration conf, String groupName, String type) {
        if (conf.metricsEnabled()) {
            return GiraphMetricsRegistry.createWithOptional(groupName, type);
        }
        return GiraphMetricsRegistry.createFake();
    }

    public Map<MetricName, Metric> getAll() {
        return this.registry.allMetrics();
    }

    public String getGroupName() {
        return this.groupName;
    }

    protected void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void printToStream(PrintStream out) {
        out.println("");
        new ConsoleReporter(this.registry, out, MetricPredicate.ALL).run();
    }

    protected MetricsRegistry getInternalRegistry() {
        return this.registry;
    }

    public Counter getCounter(String name) {
        return this.registry.newCounter(this.makeMetricName(name));
    }

    public <T> Gauge<T> getGauge(String name, Gauge<T> metric) {
        return this.registry.newGauge(this.makeMetricName(name), metric);
    }

    public Histogram getBiasedHistogram(String name) {
        return this.getHistogram(name, true);
    }

    public Histogram getUniformHistogram(String name) {
        return this.getHistogram(name, false);
    }

    private Histogram getHistogram(String name, boolean biased) {
        return this.registry.newHistogram(this.makeMetricName(name), biased);
    }

    public Meter getMeter(MeterDesc meterDesc) {
        return this.getMeter(meterDesc.getName(), meterDesc.getType(), meterDesc.getTimeUnit());
    }

    public Meter getMeter(String name, String eventType, TimeUnit timeUnit) {
        return this.registry.newMeter(this.makeMetricName(name), eventType, timeUnit);
    }

    public Timer getTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit) {
        return this.registry.newTimer(this.makeMetricName(name), durationUnit, rateUnit);
    }

    public <T> Gauge<T> getExistingGauge(String name) {
        Metric metric = (Metric)this.registry.allMetrics().get(this.makeMetricName(name));
        return metric instanceof Gauge ? (Gauge)metric : null;
    }

    protected MetricName makeMetricName(String name) {
        return new MetricName(this.groupName, this.type, name);
    }

    public void shutdown() {
        this.registry.shutdown();
    }
}

