/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.metrics;

import com.google.common.collect.Lists;
import java.io.PrintStream;
import java.util.List;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.metrics.GiraphMetricsRegistry;
import org.apache.giraph.metrics.ResetSuperstepMetricsObserver;
import org.apache.giraph.metrics.SuperstepMetricsRegistry;

public class GiraphMetrics {
    private static GiraphMetrics INSTANCE = new GiraphMetrics();
    private final SuperstepMetricsRegistry perSuperstep;
    private final GiraphMetricsRegistry perJobOptional;
    private final GiraphMetricsRegistry perJobRequired;
    private final List<ResetSuperstepMetricsObserver> observers = Lists.newArrayList();

    private GiraphMetrics() {
        this.perJobOptional = GiraphMetricsRegistry.createFake();
        this.perSuperstep = SuperstepMetricsRegistry.createFake();
        this.perJobRequired = GiraphMetricsRegistry.createWithOptional("giraph", "job");
    }

    private GiraphMetrics(GiraphConfiguration conf) {
        this.perJobOptional = GiraphMetricsRegistry.create(conf, "giraph", "job");
        this.perSuperstep = SuperstepMetricsRegistry.create(conf, -1L);
        this.perJobRequired = GiraphMetricsRegistry.createWithOptional("giraph", "job");
    }

    public static GiraphMetrics get() {
        return INSTANCE;
    }

    public static void init(GiraphConfiguration conf) {
        INSTANCE = new GiraphMetrics(conf);
    }

    public GiraphMetricsRegistry perJobOptional() {
        return this.perJobOptional;
    }

    public GiraphMetricsRegistry perJobRequired() {
        return this.perJobRequired;
    }

    public SuperstepMetricsRegistry perSuperstep() {
        return this.perSuperstep;
    }

    public synchronized void addSuperstepResetObserver(ResetSuperstepMetricsObserver observer) {
        this.observers.add(observer);
    }

    public synchronized void resetSuperstepMetrics(long superstep) {
        this.perSuperstep.setSuperstep(superstep);
        for (ResetSuperstepMetricsObserver observer : this.observers) {
            observer.newSuperstep(this.perSuperstep);
        }
    }

    public void dumpToStream(PrintStream out) {
        this.perJobOptional.printToStream(out);
        this.perJobRequired.printToStream(out);
    }

    public void shutdown() {
        this.perJobOptional.shutdown();
        this.perJobRequired.shutdown();
        this.perSuperstep.shutdown();
    }
}

