/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.metrics;

import com.google.common.collect.Maps;
import java.io.PrintStream;
import java.util.Map;
import org.apache.giraph.metrics.AggregatedMetric;
import org.apache.giraph.metrics.ValueWithHostname;
import org.apache.giraph.metrics.WorkerSuperstepMetrics;

public class AggregatedMetrics {
    private Map<String, AggregatedMetric> metrics = Maps.newHashMap();

    public AggregatedMetrics add(String name, long value, String hostnamePartitionId) {
        AggregatedMetric aggregatedMetric = this.metrics.get(name);
        if (aggregatedMetric == null) {
            aggregatedMetric = new AggregatedMetric();
            this.metrics.put(name, aggregatedMetric);
        }
        aggregatedMetric.addItem(value, hostnamePartitionId);
        return this;
    }

    public AggregatedMetrics add(WorkerSuperstepMetrics workerMetrics, String hostname) {
        this.add("superstep-time-ms", workerMetrics.getSuperstepTimer(), hostname);
        this.add("communication-time-ms", workerMetrics.getCommTimer(), hostname);
        this.add("compute-all-ms", workerMetrics.getComputeAllTimer(), hostname);
        this.add("time-to-first-message-ms", workerMetrics.getTimeToFirstMsg(), hostname);
        this.add("wait-requests-us", workerMetrics.getWaitRequestsTimer(), hostname);
        return this;
    }

    public AggregatedMetrics print(long superstep, PrintStream out) {
        AggregatedMetric superstepTime = this.get("superstep-time-ms");
        AggregatedMetric commTime = this.get("communication-time-ms");
        AggregatedMetric computeAll = this.get("compute-all-ms");
        AggregatedMetric timeToFirstMsg = this.get("time-to-first-message-ms");
        AggregatedMetric waitRequestsMicros = this.get("wait-requests-us");
        out.println();
        out.println("--- METRICS: superstep " + superstep + " ---");
        this.printAggregatedMetric(out, "superstep time", "ms", superstepTime);
        this.printAggregatedMetric(out, "compute all partitions", "ms", computeAll);
        this.printAggregatedMetric(out, "network communication time", "ms", commTime);
        this.printAggregatedMetric(out, "time to first message", "us", timeToFirstMsg);
        this.printAggregatedMetric(out, "wait requests time", "us", waitRequestsMicros);
        return this;
    }

    private void printAggregatedMetric(PrintStream out, String header, String timeUnit, AggregatedMetric aggregatedMetric) {
        if (aggregatedMetric.hasData()) {
            out.println(header);
            out.println("  mean: " + aggregatedMetric.mean() + " " + timeUnit);
            this.printValueFromHost(out, "  slowest: ", timeUnit, aggregatedMetric.max());
            this.printValueFromHost(out, "  fastest: ", timeUnit, aggregatedMetric.min());
        } else {
            out.println(header + ": NO DATA");
        }
    }

    private void printValueFromHost(PrintStream out, String prefix, String timeUnit, ValueWithHostname vh) {
        out.println(prefix + vh.getValue() + ' ' + timeUnit + " from " + vh.getHostname());
    }

    public AggregatedMetric get(String name) {
        return this.metrics.get(name);
    }

    public Map<String, AggregatedMetric> getAll() {
        return this.metrics;
    }
}

