/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.metrics;

import org.apache.giraph.metrics.ValueWithHostname;

public class AggregatedMetric {
    private ValueWithHostname min = new ValueWithHostname(Long.MAX_VALUE);
    private ValueWithHostname max = new ValueWithHostname(Long.MIN_VALUE);
    private long sum;
    private long count;

    public void addItem(long value, String hostnamePartitionId) {
        if (value < this.min.getValue()) {
            this.min.set(value, hostnamePartitionId);
        }
        if (value > this.max.getValue()) {
            this.max.set(value, hostnamePartitionId);
        }
        this.sum += value;
        ++this.count;
    }

    public boolean hasData() {
        return this.count > 0L;
    }

    public ValueWithHostname min() {
        return this.min;
    }

    public ValueWithHostname max() {
        return this.max;
    }

    public long sum() {
        return this.sum;
    }

    public double mean() {
        return (double)this.sum / (double)this.count;
    }

    public long count() {
        return this.count;
    }
}

