/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.master;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Modifier;
import org.apache.giraph.combiner.MessageCombiner;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.conf.TypesHolder;
import org.apache.giraph.graph.Computation;
import org.apache.giraph.graph.Language;
import org.apache.giraph.utils.ReflectionUtils;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

public class SuperstepClasses
implements Writable {
    private static final Logger LOG = Logger.getLogger(SuperstepClasses.class);
    private Class<? extends Computation> computationClass;
    private Class<? extends MessageCombiner> messageCombinerClass;
    private Class<? extends Writable> incomingMessageClass;
    private Class<? extends Writable> outgoingMessageClass;

    public SuperstepClasses() {
    }

    public SuperstepClasses(ImmutableClassesGiraphConfiguration conf) {
        this(conf.getComputationClass(), conf.getMessageCombinerClass());
    }

    public SuperstepClasses(Class<? extends Computation> computationClass, Class<? extends MessageCombiner> messageCombinerClass) {
        this.computationClass = computationClass;
        this.messageCombinerClass = messageCombinerClass;
    }

    public Class<? extends Computation> getComputationClass() {
        return this.computationClass;
    }

    public Class<? extends MessageCombiner> getMessageCombinerClass() {
        return this.messageCombinerClass;
    }

    public Class<? extends Writable> getIncomingMessageClass() {
        if (this.incomingMessageClass != null) {
            return this.incomingMessageClass;
        }
        if (this.computationClass == null) {
            return null;
        }
        Class<?>[] computationTypes = ReflectionUtils.getTypeArguments(TypesHolder.class, this.computationClass);
        return computationTypes[3];
    }

    public Class<? extends Writable> getOutgoingMessageClass() {
        if (this.outgoingMessageClass != null) {
            return this.outgoingMessageClass;
        }
        if (this.computationClass == null) {
            return null;
        }
        Class<?>[] computationTypes = ReflectionUtils.getTypeArguments(TypesHolder.class, this.computationClass);
        return computationTypes[4];
    }

    public void setComputationClass(Class<? extends Computation> computationClass) {
        this.computationClass = computationClass;
    }

    public void setMessageCombinerClass(Class<? extends MessageCombiner> messageCombinerClass) {
        this.messageCombinerClass = messageCombinerClass;
    }

    public void setIncomingMessageClass(Class<? extends Writable> incomingMessageClass) {
        this.incomingMessageClass = incomingMessageClass;
    }

    public void setOutgoingMessageClass(Class<? extends Writable> outgoingMessageClass) {
        this.outgoingMessageClass = outgoingMessageClass;
    }

    public void verifyTypesMatch(ImmutableClassesGiraphConfiguration conf, boolean checkMatchingMesssageTypes) {
        if (GiraphConstants.COMPUTATION_LANGUAGE.get(conf) == Language.JYTHON) {
            return;
        }
        Class<?>[] computationTypes = ReflectionUtils.getTypeArguments(TypesHolder.class, this.computationClass);
        this.verifyTypes(conf.getVertexIdClass(), computationTypes[0], "Vertex id", this.computationClass);
        this.verifyTypes(conf.getVertexValueClass(), computationTypes[1], "Vertex value", this.computationClass);
        this.verifyTypes(conf.getEdgeValueClass(), computationTypes[2], "Edge value", this.computationClass);
        Class<? extends Writable> incomingMessageType = this.getIncomingMessageClass();
        Class<? extends Writable> outgoingMessageType = this.getOutgoingMessageClass();
        if (checkMatchingMesssageTypes) {
            this.verifyTypes(incomingMessageType, conf.getOutgoingMessageValueClass(), "New incoming and previous outgoing message", this.computationClass);
        }
        if (outgoingMessageType.isInterface()) {
            throw new IllegalStateException("verifyTypesMatch: Message type must be concrete class " + outgoingMessageType);
        }
        if (Modifier.isAbstract(outgoingMessageType.getModifiers())) {
            throw new IllegalStateException("verifyTypesMatch: Message type can't be abstract class" + outgoingMessageType);
        }
        if (this.messageCombinerClass != null) {
            Class<?>[] combinerTypes = ReflectionUtils.getTypeArguments(MessageCombiner.class, this.messageCombinerClass);
            this.verifyTypes(conf.getVertexIdClass(), combinerTypes[0], "Vertex id", this.messageCombinerClass);
            this.verifyTypes(outgoingMessageType, combinerTypes[1], "Outgoing message", this.messageCombinerClass);
        }
    }

    private void verifyTypes(Class<?> expected, Class<?> actual, String typeDesc, Class<?> mainClass) {
        if (!expected.equals(actual)) {
            if (actual.isAssignableFrom(expected)) {
                LOG.warn((Object)("verifyTypes: proceeding with assignable types : " + typeDesc + " types, in " + mainClass.getName() + " " + expected + " expected, but " + actual + " found"));
            } else {
                throw new IllegalStateException("verifyTypes: " + typeDesc + " types " + "don't match, in " + mainClass.getName() + " " + expected + " expected, but " + actual + " found");
            }
        }
    }

    public void write(DataOutput output) throws IOException {
        WritableUtils.writeClass(this.computationClass, output);
        WritableUtils.writeClass(this.messageCombinerClass, output);
        WritableUtils.writeClass(this.incomingMessageClass, output);
        WritableUtils.writeClass(this.outgoingMessageClass, output);
    }

    public void readFields(DataInput input) throws IOException {
        this.computationClass = WritableUtils.readClass(input);
        this.messageCombinerClass = WritableUtils.readClass(input);
        this.incomingMessageClass = WritableUtils.readClass(input);
        this.outgoingMessageClass = WritableUtils.readClass(input);
    }

    public String toString() {
        String computationName = this.computationClass == null ? "_not_set_" : this.computationClass.getName();
        String combinerName = this.messageCombinerClass == null ? "null" : this.messageCombinerClass.getName();
        String incomingName = this.incomingMessageClass == null ? "null" : this.incomingMessageClass.getName();
        String outgoingName = this.outgoingMessageClass == null ? "null" : this.outgoingMessageClass.getName();
        return "(computation=" + computationName + ",combiner=" + combinerName + ",incoming=" + incomingName + ",outgoing=" + outgoingName + ")";
    }
}

