/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.master;

import java.util.Map;
import java.util.TreeMap;
import org.apache.giraph.bsp.ApplicationState;
import org.apache.giraph.bsp.CentralizedServiceMaster;
import org.apache.giraph.bsp.SuperstepState;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.counters.GiraphTimers;
import org.apache.giraph.graph.Computation;
import org.apache.giraph.metrics.GiraphMetrics;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Logger;

public class MasterThread<I extends WritableComparable, V extends Writable, E extends Writable>
extends Thread {
    public static final String GIRAPH_TIMERS_COUNTER_GROUP_NAME = "Giraph Timers";
    private static final Logger LOG = Logger.getLogger(MasterThread.class);
    private CentralizedServiceMaster<I, V, E> bspServiceMaster = null;
    private final Mapper.Context context;
    private final boolean superstepCounterOn;
    private double setupSecs = 0.0;
    private final Map<Long, Double> superstepSecsMap = new TreeMap<Long, Double>();

    public MasterThread(CentralizedServiceMaster<I, V, E> bspServiceMaster, Mapper.Context context) {
        super(MasterThread.class.getName());
        this.bspServiceMaster = bspServiceMaster;
        this.context = context;
        GiraphTimers.init(context);
        this.superstepCounterOn = GiraphConstants.USE_SUPERSTEP_COUNTERS.get(context.getConfiguration());
    }

    @Override
    public void run() {
        try {
            long startMillis = System.currentTimeMillis();
            long initializeMillis = 0L;
            long endMillis = 0L;
            this.bspServiceMaster.setup();
            SuperstepState superstepState = SuperstepState.INITIAL;
            if (this.bspServiceMaster.becomeMaster()) {
                this.bspServiceMaster.checkWorkers();
                initializeMillis = System.currentTimeMillis();
                GiraphTimers.getInstance().getInitializeMs().increment(initializeMillis - startMillis);
                if (this.bspServiceMaster.getRestartedSuperstep() != Long.MIN_VALUE || this.bspServiceMaster.createMappingInputSplits() != -1 && this.bspServiceMaster.createVertexInputSplits() != -1 && this.bspServiceMaster.createEdgeInputSplits() != -1) {
                    long setupMillis = System.currentTimeMillis() - initializeMillis;
                    GiraphTimers.getInstance().getSetupMs().increment(setupMillis);
                    this.setupSecs = (double)setupMillis / 1000.0;
                    while (!superstepState.isExecutionComplete()) {
                        long startSuperstepMillis = System.currentTimeMillis();
                        long cachedSuperstep = this.bspServiceMaster.getSuperstep();
                        GiraphMetrics.get().resetSuperstepMetrics(cachedSuperstep);
                        Class<? extends Computation> computationClass = this.bspServiceMaster.getMasterCompute().getComputation();
                        superstepState = this.bspServiceMaster.coordinateSuperstep();
                        long superstepMillis = System.currentTimeMillis() - startSuperstepMillis;
                        this.superstepSecsMap.put(cachedSuperstep, (double)superstepMillis / 1000.0);
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("masterThread: Coordination of superstep " + cachedSuperstep + " took " + (double)superstepMillis / 1000.0 + " seconds ended with state " + (Object)((Object)superstepState) + " and is now on superstep " + this.bspServiceMaster.getSuperstep()));
                        }
                        if (this.superstepCounterOn) {
                            String computationName = computationClass == null ? null : computationClass.getSimpleName();
                            GiraphTimers.getInstance().getSuperstepMs(cachedSuperstep, computationName).increment(superstepMillis);
                        }
                        this.bspServiceMaster.postSuperstep();
                        if (superstepState == SuperstepState.WORKER_FAILURE) {
                            this.bspServiceMaster.restartFromCheckpoint(this.bspServiceMaster.getLastGoodCheckpoint());
                        }
                        endMillis = System.currentTimeMillis();
                    }
                    this.bspServiceMaster.setJobState(ApplicationState.FINISHED, -1L, -1L);
                }
            }
            this.bspServiceMaster.cleanup(superstepState);
            if (!this.superstepSecsMap.isEmpty()) {
                GiraphTimers.getInstance().getShutdownMs().increment(System.currentTimeMillis() - endMillis);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("setup: Took " + this.setupSecs + " seconds."));
                }
                for (Map.Entry<Long, Double> entry : this.superstepSecsMap.entrySet()) {
                    if (LOG.isInfoEnabled()) {
                        if (entry.getKey() == -1L) {
                            LOG.info((Object)("input superstep: Took " + entry.getValue() + " seconds."));
                        } else {
                            LOG.info((Object)("superstep " + entry.getKey() + ": Took " + entry.getValue() + " seconds."));
                        }
                    }
                    this.context.progress();
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("shutdown: Took " + (double)(System.currentTimeMillis() - endMillis) / 1000.0 + " seconds."));
                    LOG.info((Object)("total: Took " + (double)(System.currentTimeMillis() - initializeMillis) / 1000.0 + " seconds."));
                }
                GiraphTimers.getInstance().getTotalMs().increment(System.currentTimeMillis() - initializeMillis);
            }
            this.bspServiceMaster.postApplication();
        }
        catch (Exception e) {
            LOG.error((Object)("masterThread: Master algorithm failed with " + e.getClass().getSimpleName()), (Throwable)e);
            this.bspServiceMaster.failureCleanup(e);
            throw new IllegalStateException(e);
        }
    }
}

