/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.master;

import org.apache.giraph.aggregators.Aggregator;
import org.apache.giraph.bsp.CentralizedServiceMaster;
import org.apache.giraph.combiner.MessageCombiner;
import org.apache.giraph.conf.DefaultImmutableClassesGiraphConfigurable;
import org.apache.giraph.graph.Computation;
import org.apache.giraph.graph.GraphState;
import org.apache.giraph.master.MasterAggregatorUsage;
import org.apache.giraph.master.MasterGlobalCommUsage;
import org.apache.giraph.master.SuperstepClasses;
import org.apache.giraph.reducers.ReduceOperation;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;

public abstract class MasterCompute
extends DefaultImmutableClassesGiraphConfigurable
implements MasterAggregatorUsage,
MasterGlobalCommUsage,
Writable {
    private boolean halt = false;
    private CentralizedServiceMaster serviceMaster;
    private GraphState graphState;
    private SuperstepClasses superstepClasses;

    public abstract void compute();

    public abstract void initialize() throws InstantiationException, IllegalAccessException;

    public final long getSuperstep() {
        return this.graphState.getSuperstep();
    }

    public final long getTotalNumVertices() {
        return this.graphState.getTotalNumVertices();
    }

    public final long getTotalNumEdges() {
        return this.graphState.getTotalNumEdges();
    }

    public final void haltComputation() {
        this.halt = true;
    }

    public final boolean isHalted() {
        return this.halt;
    }

    public final Mapper.Context getContext() {
        return this.graphState.getContext();
    }

    public final void setComputation(Class<? extends Computation> computationClass) {
        this.superstepClasses.setComputationClass(computationClass);
    }

    public final Class<? extends Computation> getComputation() {
        if (this.superstepClasses == null) {
            return null;
        }
        return this.superstepClasses.getComputationClass();
    }

    public final void setMessageCombiner(Class<? extends MessageCombiner> combinerClass) {
        this.superstepClasses.setMessageCombinerClass(combinerClass);
    }

    public final Class<? extends MessageCombiner> getMessageCombiner() {
        if (this.superstepClasses == null) {
            return null;
        }
        return this.superstepClasses.getMessageCombinerClass();
    }

    public final void setIncomingMessage(Class<? extends Writable> incomingMessageClass) {
        this.superstepClasses.setIncomingMessageClass(incomingMessageClass);
    }

    public final void setOutgoingMessage(Class<? extends Writable> outgoingMessageClass) {
        this.superstepClasses.setOutgoingMessageClass(outgoingMessageClass);
    }

    @Override
    public final <S, R extends Writable> void registerReduce(String name, ReduceOperation<S, R> reduceOp) {
        this.serviceMaster.getGlobalCommHandler().registerReduce(name, reduceOp);
    }

    @Override
    public final <S, R extends Writable> void registerReduce(String name, ReduceOperation<S, R> reduceOp, R globalInitialValue) {
        this.serviceMaster.getGlobalCommHandler().registerReduce(name, reduceOp, globalInitialValue);
    }

    public final <T extends Writable> T getReduced(String name) {
        return this.serviceMaster.getGlobalCommHandler().getReduced(name);
    }

    @Override
    public final void broadcast(String name, Writable object) {
        this.serviceMaster.getGlobalCommHandler().broadcast(name, object);
    }

    @Override
    public final <A extends Writable> boolean registerAggregator(String name, Class<? extends Aggregator<A>> aggregatorClass) throws InstantiationException, IllegalAccessException {
        return this.serviceMaster.getAggregatorTranslationHandler().registerAggregator(name, aggregatorClass);
    }

    @Override
    public final <A extends Writable> boolean registerPersistentAggregator(String name, Class<? extends Aggregator<A>> aggregatorClass) throws InstantiationException, IllegalAccessException {
        return this.serviceMaster.getAggregatorTranslationHandler().registerPersistentAggregator(name, aggregatorClass);
    }

    @Override
    public final <A extends Writable> A getAggregatedValue(String name) {
        return this.serviceMaster.getAggregatorTranslationHandler().getAggregatedValue(name);
    }

    @Override
    public final <A extends Writable> void setAggregatedValue(String name, A value) {
        this.serviceMaster.getAggregatorTranslationHandler().setAggregatedValue(name, value);
    }

    public void logToCommandLine(String line) {
        this.serviceMaster.getJobProgressTracker().logInfo(line);
    }

    final void setGraphState(GraphState graphState) {
        this.graphState = graphState;
    }

    final void setMasterService(CentralizedServiceMaster serviceMaster) {
        this.serviceMaster = serviceMaster;
    }

    final void setSuperstepClasses(SuperstepClasses superstepClasses) {
        this.superstepClasses = superstepClasses;
    }
}

