/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.master;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.giraph.aggregators.AggregatorWriter;
import org.apache.giraph.bsp.BspService;
import org.apache.giraph.bsp.SuperstepState;
import org.apache.giraph.comm.GlobalCommType;
import org.apache.giraph.comm.MasterClient;
import org.apache.giraph.comm.aggregators.AggregatorUtils;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.master.MasterGlobalCommUsage;
import org.apache.giraph.reducers.ReduceOperation;
import org.apache.giraph.reducers.Reducer;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;

public class MasterAggregatorHandler
implements MasterGlobalCommUsage,
Writable {
    private static final Logger LOG = Logger.getLogger(MasterAggregatorHandler.class);
    private final Map<String, Reducer<Object, Writable>> reducerMap = Maps.newHashMap();
    private final Map<String, Writable> broadcastMap = Maps.newHashMap();
    private final Map<String, Writable> reducedMap = Maps.newHashMap();
    private final AggregatorWriter aggregatorWriter;
    private final Progressable progressable;
    private final ImmutableClassesGiraphConfiguration<?, ?, ?> conf;

    public MasterAggregatorHandler(ImmutableClassesGiraphConfiguration<?, ?, ?> conf, Progressable progressable) {
        this.progressable = progressable;
        this.conf = conf;
        this.aggregatorWriter = conf.createAggregatorWriter();
    }

    @Override
    public final <S, R extends Writable> void registerReduce(String name, ReduceOperation<S, R> reduceOp) {
        this.registerReduce(name, reduceOp, reduceOp.createInitialValue());
    }

    @Override
    public <S, R extends Writable> void registerReduce(String name, ReduceOperation<S, R> reduceOp, R globalInitialValue) {
        if (this.reducerMap.containsKey(name)) {
            throw new IllegalArgumentException("Reducer with name " + name + " was already registered, " + " and is " + this.reducerMap.get(name) + ", and we are trying to " + " register " + reduceOp);
        }
        if (reduceOp == null) {
            throw new IllegalArgumentException("null reducer cannot be registered, with name " + name);
        }
        if (globalInitialValue == null) {
            throw new IllegalArgumentException("global initial value for reducer cannot be null, but is for " + reduceOp + " with naem" + name);
        }
        Reducer<S, R> reducer = new Reducer<S, R>(reduceOp, globalInitialValue);
        this.reducerMap.put(name, reducer);
    }

    public <T extends Writable> T getReduced(String name) {
        Writable value = this.reducedMap.get(name);
        if (value == null) {
            LOG.warn((Object)("getReduced: " + AggregatorUtils.getUnregisteredReducerMessage(name, this.reducedMap.size() != 0, this.conf)));
        }
        return (T)value;
    }

    @Override
    public void broadcast(String name, Writable object) {
        if (this.broadcastMap.containsKey(name)) {
            throw new IllegalArgumentException("Value already broadcasted for name " + name);
        }
        if (object == null) {
            throw new IllegalArgumentException("null cannot be broadcasted");
        }
        this.broadcastMap.put(name, object);
    }

    public void prepareSuperstep() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"prepareSuperstep: Start preparing reducers");
        }
        Preconditions.checkState((boolean)this.reducedMap.isEmpty(), (Object)"reducedMap must be empty before start of the superstep");
        Preconditions.checkState((boolean)this.broadcastMap.isEmpty(), (Object)"broadcastMap must be empty before start of the superstep");
        for (Map.Entry<String, Reducer<Object, Writable>> entry : this.reducerMap.entrySet()) {
            Writable value = entry.getValue().getCurrentValue();
            if (value == null) {
                value = entry.getValue().createInitialValue();
            }
            this.reducedMap.put(entry.getKey(), value);
        }
        this.reducerMap.clear();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"prepareSuperstep: Aggregators prepared");
        }
    }

    public void finishSuperstep() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"finishSuperstep: Start finishing aggregators");
        }
        this.reducedMap.clear();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"finishSuperstep: Aggregators finished");
        }
    }

    public void sendDataToOwners(MasterClient masterClient) {
        try {
            for (Map.Entry<String, Reducer<Object, Writable>> entry : this.reducerMap.entrySet()) {
                masterClient.sendToOwner(entry.getKey(), GlobalCommType.REDUCE_OPERATIONS, entry.getValue().getReduceOp());
                this.progressable.progress();
            }
            for (Map.Entry<String, Reducer<Object, Writable>> entry : this.broadcastMap.entrySet()) {
                masterClient.sendToOwner(entry.getKey(), GlobalCommType.BROADCAST, (Writable)entry.getValue());
                this.progressable.progress();
            }
            masterClient.finishSendingValues();
            this.broadcastMap.clear();
        }
        catch (IOException e) {
            throw new IllegalStateException("finishSuperstep: IOException occurred while sending aggregators", e);
        }
    }

    public void acceptReducedValues(DataInput reducedValuesInput) throws IOException {
        int numReducers = reducedValuesInput.readInt();
        for (int i = 0; i < numReducers; ++i) {
            String name = reducedValuesInput.readUTF();
            GlobalCommType type = GlobalCommType.values()[reducedValuesInput.readByte()];
            if (type != GlobalCommType.REDUCED_VALUE) {
                throw new IllegalStateException("SendReducedToMasterRequest received " + (Object)((Object)type));
            }
            Reducer<Object, Writable> reducer = this.reducerMap.get(name);
            if (reducer == null) {
                throw new IllegalStateException("acceptReducedValues: Master received reduced value which isn't registered: " + name);
            }
            Writable valueToReduce = reducer.createInitialValue();
            valueToReduce.readFields(reducedValuesInput);
            if (reducer.getCurrentValue() != null) {
                reducer.reducePartial(valueToReduce);
            } else {
                reducer.setCurrentValue(valueToReduce);
            }
            this.progressable.progress();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("acceptReducedValues: Accepted one set with " + numReducers + " aggregated values"));
        }
    }

    public void writeAggregators(long superstep, SuperstepState superstepState) {
        try {
            this.aggregatorWriter.writeAggregator(this.reducedMap.entrySet(), superstepState == SuperstepState.ALL_SUPERSTEPS_DONE ? -1L : superstep);
        }
        catch (IOException e) {
            throw new IllegalStateException("coordinateSuperstep: IOException while writing aggregators data", e);
        }
    }

    public void initialize(BspService service) {
        try {
            this.aggregatorWriter.initialize(service.getContext(), service.getApplicationAttempt());
        }
        catch (IOException e) {
            throw new IllegalStateException("initialize: Couldn't initialize aggregatorWriter", e);
        }
    }

    public void close() throws IOException {
        this.aggregatorWriter.close();
    }

    public void write(DataOutput out) throws IOException {
        Preconditions.checkState((boolean)this.reducedMap.isEmpty(), (Object)"reducedMap must be empty at the end of the superstep");
        out.writeInt(this.reducerMap.size());
        for (Map.Entry<String, Reducer<Object, Writable>> entry : this.reducerMap.entrySet()) {
            out.writeUTF(entry.getKey());
            entry.getValue().write(out);
            this.progressable.progress();
        }
        out.writeInt(this.broadcastMap.size());
        for (Map.Entry<String, Reducer<Object, Writable>> entry : this.broadcastMap.entrySet()) {
            out.writeUTF(entry.getKey());
            WritableUtils.writeWritableObject((Writable)entry.getValue(), out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.reducedMap.clear();
        this.broadcastMap.clear();
        this.reducerMap.clear();
        int numReducers = in.readInt();
        for (int i = 0; i < numReducers; ++i) {
            String name = in.readUTF();
            Reducer reducer = new Reducer();
            reducer.readFields(in, this.conf);
            this.reducerMap.put(name, reducer);
        }
        int numBroadcast = in.readInt();
        for (int i = 0; i < numBroadcast; ++i) {
            String name = in.readUTF();
            Object value = WritableUtils.readWritableObject(in, this.conf);
            this.broadcastMap.put(name, (Writable)value);
        }
    }
}

