/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.master;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.iharder.Base64;
import org.apache.commons.io.FilenameUtils;
import org.apache.giraph.bsp.ApplicationState;
import org.apache.giraph.bsp.BspInputFormat;
import org.apache.giraph.bsp.BspService;
import org.apache.giraph.bsp.CentralizedServiceMaster;
import org.apache.giraph.bsp.CheckpointStatus;
import org.apache.giraph.bsp.SuperstepState;
import org.apache.giraph.comm.MasterClient;
import org.apache.giraph.comm.MasterServer;
import org.apache.giraph.comm.netty.NettyMasterClient;
import org.apache.giraph.comm.netty.NettyMasterServer;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.counters.GiraphStats;
import org.apache.giraph.graph.AddressesAndPartitionsWritable;
import org.apache.giraph.graph.GlobalStats;
import org.apache.giraph.graph.GraphFunctions;
import org.apache.giraph.graph.GraphState;
import org.apache.giraph.graph.GraphTaskManager;
import org.apache.giraph.graph.InputSplitEvents;
import org.apache.giraph.graph.InputSplitPaths;
import org.apache.giraph.io.GiraphInputFormat;
import org.apache.giraph.io.internal.WrappedEdgeInputFormat;
import org.apache.giraph.io.internal.WrappedMappingInputFormat;
import org.apache.giraph.io.internal.WrappedVertexInputFormat;
import org.apache.giraph.master.AggregatorToGlobalCommTranslation;
import org.apache.giraph.master.MasterAggregatorHandler;
import org.apache.giraph.master.MasterCompute;
import org.apache.giraph.master.MasterInfo;
import org.apache.giraph.master.MasterObserver;
import org.apache.giraph.master.SuperstepClasses;
import org.apache.giraph.metrics.AggregatedMetrics;
import org.apache.giraph.metrics.GiraphMetrics;
import org.apache.giraph.metrics.GiraphTimer;
import org.apache.giraph.metrics.GiraphTimerContext;
import org.apache.giraph.metrics.ResetSuperstepMetricsObserver;
import org.apache.giraph.metrics.SuperstepMetricsRegistry;
import org.apache.giraph.metrics.WorkerSuperstepMetrics;
import org.apache.giraph.partition.BasicPartitionOwner;
import org.apache.giraph.partition.MasterGraphPartitioner;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.partition.PartitionStats;
import org.apache.giraph.partition.PartitionUtils;
import org.apache.giraph.time.SystemTime;
import org.apache.giraph.time.Time;
import org.apache.giraph.utils.CheckpointingUtils;
import org.apache.giraph.utils.JMapHistoDumper;
import org.apache.giraph.utils.LogStacktraceCallable;
import org.apache.giraph.utils.ProgressableUtils;
import org.apache.giraph.utils.ReactiveJMapHistoDumper;
import org.apache.giraph.utils.WritableUtils;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.giraph.zk.BspEvent;
import org.apache.giraph.zk.PredicateLock;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.json.JSONException;
import org.json.JSONObject;

public class BspServiceMaster<I extends WritableComparable, V extends Writable, E extends Writable>
extends BspService<I, V, E>
implements CentralizedServiceMaster<I, V, E>,
ResetSuperstepMetricsObserver {
    public static final int MAX_PRINTABLE_REMAINING_WORKERS = 10;
    public static final String NUM_MASTER_ZK_INPUT_SPLIT_THREADS = "giraph.numMasterZkInputSplitThreads";
    public static final int DEFAULT_INPUT_SPLIT_THREAD_COUNT = 1;
    private static final Time TIME = SystemTime.get();
    private static final Logger LOG = Logger.getLogger(BspServiceMaster.class);
    private boolean isMaster = false;
    private final int maxWorkers;
    private final int minWorkers;
    private final int maxNumberOfSupersteps;
    private final float minPercentResponded;
    private final int eventWaitMsecs;
    private final int maxSuperstepWaitMsecs;
    private final int partitionLongTailMinPrint;
    private long lastCheckpointedSuperstep = -1L;
    private final BspEvent workerWroteCheckpoint;
    private final BspEvent superstepStateChanged;
    private final MasterGraphPartitioner<I, V, E> masterGraphPartitioner;
    private final List<PartitionStats> allPartitionStatsList = new ArrayList<PartitionStats>();
    private MasterAggregatorHandler globalCommHandler;
    private AggregatorToGlobalCommTranslation aggregatorTranslation;
    private MasterCompute masterCompute;
    private MasterClient masterClient;
    private MasterServer masterServer;
    private MasterInfo masterInfo;
    private List<WorkerInfo> chosenWorkerInfoList = Lists.newArrayList();
    private final int localityLimit = 5;
    private final MasterObserver[] observers;
    private GiraphTimer masterComputeTimer;
    private final int checkpointFrequency;
    private CheckpointStatus checkpointStatus;

    public BspServiceMaster(Mapper.Context context, GraphTaskManager<I, V, E> graphTaskManager) {
        super(context, graphTaskManager);
        this.workerWroteCheckpoint = new PredicateLock((Progressable)context);
        this.registerBspEvent(this.workerWroteCheckpoint);
        this.superstepStateChanged = new PredicateLock((Progressable)context);
        this.registerBspEvent(this.superstepStateChanged);
        ImmutableClassesGiraphConfiguration conf = this.getConfiguration();
        this.maxWorkers = conf.getMaxWorkers();
        this.minWorkers = conf.getMinWorkers();
        this.maxNumberOfSupersteps = conf.getMaxNumberOfSupersteps();
        this.minPercentResponded = GiraphConstants.MIN_PERCENT_RESPONDED.get(conf);
        this.eventWaitMsecs = conf.getEventWaitMsecs();
        this.maxSuperstepWaitMsecs = conf.getMaxMasterSuperstepWaitMsecs();
        this.partitionLongTailMinPrint = GiraphConstants.PARTITION_LONG_TAIL_MIN_PRINT.get(conf);
        this.masterGraphPartitioner = this.getGraphPartitionerFactory().createMasterGraphPartitioner();
        if (conf.isJMapHistogramDumpEnabled()) {
            conf.addMasterObserverClass(JMapHistoDumper.class);
        }
        if (conf.isReactiveJmapHistogramDumpEnabled()) {
            conf.addMasterObserverClass(ReactiveJMapHistoDumper.class);
        }
        this.observers = conf.createMasterObservers();
        this.checkpointFrequency = conf.getCheckpointFrequency();
        this.checkpointStatus = CheckpointStatus.NONE;
        GiraphMetrics.get().addSuperstepResetObserver(this);
        GiraphStats.init(context);
    }

    @Override
    public void newSuperstep(SuperstepMetricsRegistry superstepMetrics) {
        this.masterComputeTimer = new GiraphTimer(superstepMetrics, "master-compute-call", TimeUnit.MILLISECONDS);
    }

    @Override
    public void setJobState(ApplicationState state, long applicationAttempt, long desiredSuperstep) {
        this.setJobState(state, applicationAttempt, desiredSuperstep, true);
    }

    private void setJobState(ApplicationState state, long applicationAttempt, long desiredSuperstep, boolean killJobOnFailure) {
        JSONObject jobState = new JSONObject();
        try {
            jobState.put("_stateKey", (Object)state.toString());
            jobState.put("_applicationAttemptKey", applicationAttempt);
            jobState.put("_superstepKey", desiredSuperstep);
        }
        catch (JSONException e) {
            throw new RuntimeException("setJobState: Couldn't put " + state.toString());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("setJobState: " + jobState.toString() + " on superstep " + this.getSuperstep()));
        }
        try {
            this.getZkExt().createExt(this.masterJobStatePath + "/jobState", jobState.toString().getBytes(Charset.defaultCharset()), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL, true);
            LOG.info((Object)("setJobState: " + jobState));
        }
        catch (KeeperException.NodeExistsException e) {
            throw new IllegalStateException("setJobState: Imposible that " + this.masterJobStatePath + " already exists!", e);
        }
        catch (KeeperException e) {
            throw new IllegalStateException("setJobState: Unknown KeeperException for " + this.masterJobStatePath, e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("setJobState: Unknown InterruptedException for " + this.masterJobStatePath, e);
        }
        if (state == ApplicationState.FAILED && killJobOnFailure) {
            this.failJob(new IllegalStateException("FAILED"));
        }
    }

    private void setJobStateFailed(String reason) {
        this.getGraphTaskManager().getJobProgressTracker().logFailure(reason);
        this.setJobState(ApplicationState.FAILED, -1L, -1L, false);
        this.failJob(new IllegalStateException(reason));
    }

    private List<InputSplit> generateInputSplits(GiraphInputFormat inputFormat, int minSplitCountHint, String inputSplitType) {
        List<InputSplit> splits;
        String logPrefix = "generate" + inputSplitType + "InputSplits";
        try {
            splits = inputFormat.getSplits((JobContext)this.getContext(), minSplitCountHint);
        }
        catch (IOException e) {
            throw new IllegalStateException(logPrefix + ": Got IOException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(logPrefix + ": Got InterruptedException", e);
        }
        float samplePercent = GiraphConstants.INPUT_SPLIT_SAMPLE_PERCENT.get(this.getConfiguration());
        if (samplePercent != GiraphConstants.INPUT_SPLIT_SAMPLE_PERCENT.getDefaultValue()) {
            int lastIndex = (int)(samplePercent * (float)splits.size() / 100.0f);
            List<InputSplit> sampleSplits = splits.subList(0, lastIndex);
            LOG.warn((Object)(logPrefix + ": Using sampling - Processing only " + sampleSplits.size() + " instead of " + splits.size() + " expected splits."));
            return sampleSplits;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(logPrefix + ": Got " + splits.size() + " input splits for " + minSplitCountHint + " input threads"));
        }
        return splits;
    }

    private void failJob(Exception e) {
        LOG.fatal((Object)("failJob: Killing job " + this.getJobId()));
        LOG.fatal((Object)("failJob: exception " + e.toString()));
        try {
            JobID jobId;
            if (this.getConfiguration().isPureYarnJob()) {
                throw new RuntimeException("BspServiceMaster (YARN profile) is FAILING this task, throwing exception to end job run.", e);
            }
            JobClient jobClient = new JobClient((JobConf)this.getContext().getConfiguration());
            RunningJob job = jobClient.getJob(jobId = JobID.forName((String)this.getJobId()));
            if (job != null) {
                job.killJob();
            } else {
                LOG.error((Object)("Jon not found for jobId=" + this.getJobId()));
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            this.failureCleanup(e);
        }
    }

    private List<WorkerInfo> getWorkerInfosFromPath(String workerInfosPath, boolean watch) {
        List<String> workerInfoPathList;
        ArrayList<WorkerInfo> workerInfoList = new ArrayList<WorkerInfo>();
        try {
            workerInfoPathList = this.getZkExt().getChildrenExt(workerInfosPath, watch, false, true);
        }
        catch (KeeperException e) {
            throw new IllegalStateException("getWorkers: Got KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("getWorkers: Got InterruptedStateException", e);
        }
        for (String workerInfoPath : workerInfoPathList) {
            WorkerInfo workerInfo = new WorkerInfo();
            WritableUtils.readFieldsFromZnode(this.getZkExt(), workerInfoPath, true, null, workerInfo);
            workerInfoList.add(workerInfo);
        }
        return workerInfoList;
    }

    private void getAllWorkerInfos(long superstep, List<WorkerInfo> healthyWorkerInfoList, List<WorkerInfo> unhealthyWorkerInfoList) {
        String healthyWorkerInfoPath = this.getWorkerInfoHealthyPath(this.getApplicationAttempt(), superstep);
        String unhealthyWorkerInfoPath = this.getWorkerInfoUnhealthyPath(this.getApplicationAttempt(), superstep);
        try {
            this.getZkExt().createOnceExt(healthyWorkerInfoPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
        }
        catch (KeeperException e) {
            throw new IllegalStateException("getWorkers: KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("getWorkers: InterruptedException", e);
        }
        try {
            this.getZkExt().createOnceExt(unhealthyWorkerInfoPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
        }
        catch (KeeperException e) {
            throw new IllegalStateException("getWorkers: KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("getWorkers: InterruptedException", e);
        }
        List<WorkerInfo> currentHealthyWorkerInfoList = this.getWorkerInfosFromPath(healthyWorkerInfoPath, true);
        List<WorkerInfo> currentUnhealthyWorkerInfoList = this.getWorkerInfosFromPath(unhealthyWorkerInfoPath, false);
        healthyWorkerInfoList.clear();
        if (currentHealthyWorkerInfoList != null) {
            for (WorkerInfo healthyWorkerInfo : currentHealthyWorkerInfoList) {
                healthyWorkerInfoList.add(healthyWorkerInfo);
            }
        }
        unhealthyWorkerInfoList.clear();
        if (currentUnhealthyWorkerInfoList != null) {
            for (WorkerInfo unhealthyWorkerInfo : currentUnhealthyWorkerInfoList) {
                unhealthyWorkerInfoList.add(unhealthyWorkerInfo);
            }
        }
    }

    @Override
    public List<WorkerInfo> checkWorkers() {
        boolean failJob = true;
        long failWorkerCheckMsecs = SystemTime.get().getMilliseconds() + (long)this.maxSuperstepWaitMsecs;
        ArrayList<WorkerInfo> healthyWorkerInfoList = new ArrayList<WorkerInfo>();
        ArrayList<WorkerInfo> unhealthyWorkerInfoList = new ArrayList<WorkerInfo>();
        int totalResponses = -1;
        while (SystemTime.get().getMilliseconds() < failWorkerCheckMsecs) {
            this.getContext().progress();
            this.getAllWorkerInfos(this.getSuperstep(), healthyWorkerInfoList, unhealthyWorkerInfoList);
            totalResponses = healthyWorkerInfoList.size() + unhealthyWorkerInfoList.size();
            if ((float)totalResponses * 100.0f / (float)this.maxWorkers >= this.minPercentResponded) {
                failJob = false;
                break;
            }
            this.getContext().setStatus((Object)((Object)this.getGraphTaskManager().getGraphFunctions()) + " " + "checkWorkers: Only found " + totalResponses + " responses of " + this.maxWorkers + " needed to start superstep " + this.getSuperstep());
            if (this.getWorkerHealthRegistrationChangedEvent().waitMsecs(this.eventWaitMsecs)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"checkWorkers: Got event that health registration changed, not using poll attempt");
                }
                this.getWorkerHealthRegistrationChangedEvent().reset();
                continue;
            }
            if (!LOG.isInfoEnabled()) continue;
            LOG.info((Object)("checkWorkers: Only found " + totalResponses + " responses of " + this.maxWorkers + " needed to start superstep " + this.getSuperstep() + ".  Reporting every " + this.eventWaitMsecs + " msecs, " + (failWorkerCheckMsecs - SystemTime.get().getMilliseconds()) + " more msecs left before giving up."));
            if (this.maxWorkers - totalResponses > this.partitionLongTailMinPrint) continue;
            this.logMissingWorkersOnSuperstep(healthyWorkerInfoList, unhealthyWorkerInfoList);
        }
        if (failJob) {
            LOG.error((Object)("checkWorkers: Did not receive enough processes in time (only " + totalResponses + " of " + this.minWorkers + " required) after waiting " + this.maxSuperstepWaitMsecs + "msecs).  This occurs if you do not have enough map tasks " + "available simultaneously on your Hadoop instance to fulfill " + "the number of requested workers."));
            return null;
        }
        if (healthyWorkerInfoList.size() < this.minWorkers) {
            LOG.error((Object)("checkWorkers: Only " + healthyWorkerInfoList.size() + " available when " + this.minWorkers + " are required."));
            this.logMissingWorkersOnSuperstep(healthyWorkerInfoList, unhealthyWorkerInfoList);
            return null;
        }
        this.getContext().setStatus((Object)((Object)this.getGraphTaskManager().getGraphFunctions()) + " " + "checkWorkers: Done - Found " + totalResponses + " responses of " + this.maxWorkers + " needed to start superstep " + this.getSuperstep());
        return healthyWorkerInfoList;
    }

    private void logMissingWorkersOnSuperstep(List<WorkerInfo> healthyWorkerInfoList, List<WorkerInfo> unhealthyWorkerInfoList) {
        if (LOG.isInfoEnabled()) {
            TreeSet<Integer> partitionSet = new TreeSet<Integer>();
            for (WorkerInfo workerInfo : healthyWorkerInfoList) {
                partitionSet.add(workerInfo.getTaskId());
            }
            for (WorkerInfo workerInfo : unhealthyWorkerInfoList) {
                partitionSet.add(workerInfo.getTaskId());
            }
            for (int i = 1; i <= this.maxWorkers; ++i) {
                if (partitionSet.contains(i) || i == this.getTaskPartition()) continue;
                LOG.info((Object)("logMissingWorkersOnSuperstep: No response from partition " + i + " (could be master)"));
            }
        }
    }

    private int createInputSplits(GiraphInputFormat inputFormat, InputSplitPaths inputSplitPaths, String inputSplitType) {
        ImmutableClassesGiraphConfiguration conf = this.getConfiguration();
        String logPrefix = "create" + inputSplitType + "InputSplits";
        String inputSplitsPath = inputSplitPaths.getPath();
        try {
            if (this.getZkExt().exists(inputSplitsPath, false) != null) {
                LOG.info((Object)(inputSplitsPath + " already exists, no need to create"));
                return Integer.parseInt(new String(this.getZkExt().getData(inputSplitsPath, false, null), Charset.defaultCharset()));
            }
        }
        catch (KeeperException.NoNodeException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)(logPrefix + ": Need to create the input splits at " + inputSplitsPath));
            }
        }
        catch (KeeperException e) {
            throw new IllegalStateException(logPrefix + ": KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(logPrefix + ": InterruptedException", e);
        }
        List<WorkerInfo> healthyWorkerInfoList = this.checkWorkers();
        if (healthyWorkerInfoList == null) {
            this.setJobStateFailed("Not enough healthy workers to create input splits");
            return -1;
        }
        int minSplitCountHint = healthyWorkerInfoList.size() * conf.getNumInputSplitsThreads();
        List<InputSplit> splitList = this.generateInputSplits(inputFormat, minSplitCountHint, inputSplitType);
        if (splitList.isEmpty()) {
            LOG.fatal((Object)(logPrefix + ": Failing job due to 0 input splits, " + "check input of " + inputFormat.getClass().getName() + "!"));
            this.getContext().setStatus("Failing job due to 0 input splits, check input of " + inputFormat.getClass().getName() + "!");
            this.setJobStateFailed("Please check your input tables - partitions which you specified are missing. Failing the job!!!");
        }
        if (minSplitCountHint > splitList.size()) {
            LOG.warn((Object)(logPrefix + ": Number of inputSplits=" + splitList.size() + " < " + minSplitCountHint + "=total number of input threads, " + "some threads will be not used"));
        }
        int inputSplitThreadCount = conf.getInt(NUM_MASTER_ZK_INPUT_SPLIT_THREADS, 1);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(logPrefix + ": Starting to write input split data " + "to zookeeper with " + inputSplitThreadCount + " threads"));
        }
        ExecutorService taskExecutor = Executors.newFixedThreadPool(inputSplitThreadCount);
        boolean writeLocations = GiraphConstants.USE_INPUT_SPLIT_LOCALITY.get(conf);
        for (int i = 0; i < splitList.size(); ++i) {
            InputSplit inputSplit = splitList.get(i);
            taskExecutor.submit(new LogStacktraceCallable<Void>(new WriteInputSplit(inputFormat, inputSplit, inputSplitsPath, i, writeLocations)));
        }
        taskExecutor.shutdown();
        ProgressableUtils.awaitExecutorTermination(taskExecutor, (Progressable)this.getContext());
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)(logPrefix + ": Done writing input split data to zookeeper"));
        }
        try {
            this.getZkExt().createExt(inputSplitPaths.getAllReadyPath(), null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
        }
        catch (KeeperException.NodeExistsException e) {
            LOG.info((Object)(logPrefix + ": Node " + inputSplitPaths.getAllReadyPath() + " already exists."));
        }
        catch (KeeperException e) {
            throw new IllegalStateException(logPrefix + ": KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(logPrefix + ": IllegalStateException", e);
        }
        return splitList.size();
    }

    @Override
    public int createMappingInputSplits() {
        if (!this.getConfiguration().hasMappingInputFormat()) {
            return 0;
        }
        WrappedMappingInputFormat mappingInputFormat = this.getConfiguration().createWrappedMappingInputFormat();
        return this.createInputSplits(mappingInputFormat, this.mappingInputSplitsPaths, "Mapping");
    }

    @Override
    public int createVertexInputSplits() {
        if (!this.getConfiguration().hasVertexInputFormat()) {
            return 0;
        }
        WrappedVertexInputFormat vertexInputFormat = this.getConfiguration().createWrappedVertexInputFormat();
        return this.createInputSplits(vertexInputFormat, this.vertexInputSplitsPaths, "Vertex");
    }

    @Override
    public int createEdgeInputSplits() {
        if (!this.getConfiguration().hasEdgeInputFormat()) {
            return 0;
        }
        WrappedEdgeInputFormat edgeInputFormat = this.getConfiguration().createWrappedEdgeInputFormat();
        return this.createInputSplits(edgeInputFormat, this.edgeInputSplitsPaths, "Edge");
    }

    @Override
    public List<WorkerInfo> getWorkerInfoList() {
        return this.chosenWorkerInfoList;
    }

    @Override
    public MasterAggregatorHandler getGlobalCommHandler() {
        return this.globalCommHandler;
    }

    @Override
    public AggregatorToGlobalCommTranslation getAggregatorTranslationHandler() {
        return this.aggregatorTranslation;
    }

    @Override
    public MasterCompute getMasterCompute() {
        return this.masterCompute;
    }

    private Collection<PartitionOwner> prepareCheckpointRestart(long superstep) throws IOException, KeeperException, InterruptedException {
        ArrayList<PartitionOwner> partitionOwners = new ArrayList<PartitionOwner>();
        FileSystem fs = this.getFs();
        String finalizedCheckpointPath = this.getSavedCheckpointBasePath(superstep) + ".finalized";
        LOG.info((Object)("Loading checkpoint from " + finalizedCheckpointPath));
        FSDataInputStream finalizedStream = fs.open(new Path(finalizedCheckpointPath));
        GlobalStats globalStats = new GlobalStats();
        globalStats.readFields((DataInput)finalizedStream);
        this.updateCounters(globalStats);
        SuperstepClasses superstepClasses = new SuperstepClasses();
        superstepClasses.readFields((DataInput)finalizedStream);
        this.getConfiguration().updateSuperstepClasses(superstepClasses);
        int prefixFileCount = finalizedStream.readInt();
        Int2ObjectOpenHashMap workersMap = new Int2ObjectOpenHashMap();
        for (WorkerInfo worker : this.chosenWorkerInfoList) {
            workersMap.put(worker.getTaskId(), (Object)worker);
        }
        String checkpointFile = finalizedStream.readUTF();
        for (int i = 0; i < prefixFileCount; ++i) {
            int mrTaskId = finalizedStream.readInt();
            FSDataInputStream metadataStream = fs.open(new Path(checkpointFile + "." + mrTaskId + ".metadata"));
            long partitions = metadataStream.readInt();
            WorkerInfo worker = (WorkerInfo)workersMap.get(mrTaskId);
            for (long p = 0L; p < partitions; ++p) {
                int partitionId = metadataStream.readInt();
                BasicPartitionOwner partitionOwner = new BasicPartitionOwner(partitionId, worker);
                partitionOwners.add(partitionOwner);
                LOG.info((Object)("prepareCheckpointRestart partitionId=" + partitionId + " assigned to " + partitionOwner));
            }
            metadataStream.close();
        }
        Collections.sort(partitionOwners, new Comparator<PartitionOwner>(){

            @Override
            public int compare(PartitionOwner p1, PartitionOwner p2) {
                return Integer.compare(p1.getPartitionId(), p2.getPartitionId());
            }
        });
        this.globalCommHandler.readFields((DataInput)finalizedStream);
        this.aggregatorTranslation.readFields((DataInput)finalizedStream);
        this.masterCompute.readFields((DataInput)finalizedStream);
        finalizedStream.close();
        return partitionOwners;
    }

    @Override
    public void setup() {
        if (this.getRestartedSuperstep() != Long.MIN_VALUE) {
            GiraphStats.getInstance().getSuperstepCounter().setValue(this.getRestartedSuperstep());
        }
        for (MasterObserver observer : this.observers) {
            observer.preApplication();
            this.getContext().progress();
        }
    }

    @Override
    public boolean becomeMaster() {
        String myBid = null;
        try {
            myBid = this.getZkExt().createExt(this.masterElectionPath + "/" + this.getHostnamePartitionId(), null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, true);
        }
        catch (KeeperException e) {
            throw new IllegalStateException("becomeMaster: KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("becomeMaster: IllegalStateException", e);
        }
        while (true) {
            JSONObject jobState = this.getJobState();
            try {
                if (jobState != null && ApplicationState.valueOf(jobState.getString("_stateKey")) == ApplicationState.FINISHED) {
                    LOG.info((Object)"becomeMaster: Job is finished, give up trying to be the master!");
                    this.isMaster = false;
                    return this.isMaster;
                }
            }
            catch (JSONException e) {
                throw new IllegalStateException("becomeMaster: Couldn't get state from " + jobState, e);
            }
            try {
                List<String> masterChildArr = this.getZkExt().getChildrenExt(this.masterElectionPath, true, true, true);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("becomeMaster: First child is '" + masterChildArr.get(0) + "' and my bid is '" + myBid + "'"));
                }
                if (masterChildArr.get(0).equals(myBid)) {
                    GiraphStats.getInstance().getCurrentMasterTaskPartition().setValue(this.getTaskPartition());
                    this.globalCommHandler = new MasterAggregatorHandler(this.getConfiguration(), (Progressable)this.getContext());
                    this.aggregatorTranslation = new AggregatorToGlobalCommTranslation(this.getConfiguration(), this.globalCommHandler);
                    this.globalCommHandler.initialize(this);
                    this.masterCompute = this.getConfiguration().createMasterCompute();
                    this.masterCompute.setMasterService(this);
                    this.masterInfo = new MasterInfo();
                    this.masterServer = new NettyMasterServer(this.getConfiguration(), this, (Progressable)this.getContext(), this.getGraphTaskManager().createUncaughtExceptionHandler());
                    this.masterInfo.setInetSocketAddress(this.masterServer.getMyAddress());
                    this.masterInfo.setTaskId(this.getTaskPartition());
                    this.masterClient = new NettyMasterClient(this.getContext(), this.getConfiguration(), this, this.getGraphTaskManager().createUncaughtExceptionHandler());
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)"becomeMaster: I am now the master!");
                    }
                    this.isMaster = true;
                    return this.isMaster;
                }
                LOG.info((Object)"becomeMaster: Waiting to become the master...");
                this.getMasterElectionChildrenChangedEvent().waitForever();
                this.getMasterElectionChildrenChangedEvent().reset();
            }
            catch (KeeperException e) {
                throw new IllegalStateException("becomeMaster: KeeperException", e);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("becomeMaster: IllegalStateException", e);
            }
        }
    }

    @Override
    public MasterInfo getMasterInfo() {
        return this.masterInfo;
    }

    private GlobalStats aggregateWorkerStats(long superstep) {
        ImmutableClassesGiraphConfiguration conf = this.getConfiguration();
        Class<?> partitionStatsClass = this.masterGraphPartitioner.createPartitionStats().getClass();
        GlobalStats globalStats = new GlobalStats();
        String workerFinishedPath = this.getWorkerFinishedPath(this.getApplicationAttempt(), superstep);
        List<String> workerFinishedPathList = null;
        try {
            workerFinishedPathList = this.getZkExt().getChildrenExt(workerFinishedPath, false, false, true);
        }
        catch (KeeperException e) {
            throw new IllegalStateException("aggregateWorkerStats: KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("aggregateWorkerStats: InterruptedException", e);
        }
        AggregatedMetrics aggregatedMetrics = new AggregatedMetrics();
        this.allPartitionStatsList.clear();
        for (String finishedPath : workerFinishedPathList) {
            String hostnamePartitionId = FilenameUtils.getName((String)finishedPath);
            JSONObject workerFinishedInfoObj = null;
            try {
                byte[] zkData = this.getZkExt().getData(finishedPath, false, null);
                workerFinishedInfoObj = new JSONObject(new String(zkData, Charset.defaultCharset()));
                List<PartitionStats> statsList = WritableUtils.readListFieldsFromByteArray(Base64.decode((String)workerFinishedInfoObj.getString("_partitionStatsKey")), partitionStatsClass, conf);
                for (PartitionStats partitionStats : statsList) {
                    globalStats.addPartitionStats(partitionStats);
                    this.allPartitionStatsList.add(partitionStats);
                }
                globalStats.addMessageCount(workerFinishedInfoObj.getLong("_numMsgsKey"));
                globalStats.addMessageBytesCount(workerFinishedInfoObj.getLong("_numMsgBytesKey"));
                if (!conf.metricsEnabled() || !workerFinishedInfoObj.has("_metricsKey")) continue;
                WorkerSuperstepMetrics workerMetrics = new WorkerSuperstepMetrics();
                WritableUtils.readFieldsFromByteArray(Base64.decode((String)workerFinishedInfoObj.getString("_metricsKey")), workerMetrics);
                aggregatedMetrics.add(workerMetrics, hostnamePartitionId);
            }
            catch (JSONException e) {
                throw new IllegalStateException("aggregateWorkerStats: JSONException", e);
            }
            catch (KeeperException e) {
                throw new IllegalStateException("aggregateWorkerStats: KeeperException", e);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("aggregateWorkerStats: InterruptedException", e);
            }
            catch (IOException e) {
                throw new IllegalStateException("aggregateWorkerStats: IOException", e);
            }
        }
        if (conf.metricsEnabled()) {
            if (GiraphConstants.METRICS_DIRECTORY.isDefaultValue(conf)) {
                aggregatedMetrics.print(superstep, System.err);
            } else {
                this.printAggregatedMetricsToHDFS(superstep, aggregatedMetrics);
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("aggregateWorkerStats: Aggregation found " + globalStats + " on superstep = " + this.getSuperstep()));
        }
        return globalStats;
    }

    private void printAggregatedMetricsToHDFS(long superstep, AggregatedMetrics aggregatedMetrics) {
        ImmutableClassesGiraphConfiguration conf = this.getConfiguration();
        PrintStream out = null;
        Path dir = new Path(GiraphConstants.METRICS_DIRECTORY.get(conf));
        Path outFile = new Path(GiraphConstants.METRICS_DIRECTORY.get(conf) + '/' + "superstep_" + superstep + ".metrics");
        try {
            FileSystem fs = FileSystem.get(conf);
            if (!fs.exists(dir)) {
                fs.mkdirs(dir);
            }
            if (fs.exists(outFile)) {
                throw new RuntimeException("printAggregatedMetricsToHDFS: metrics file exists");
            }
            out = new PrintStream((OutputStream)fs.create(outFile), false, Charset.defaultCharset().name());
            aggregatedMetrics.print(superstep, out);
        }
        catch (IOException e) {
            throw new RuntimeException("printAggregatedMetricsToHDFS: error creating metrics file", e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void finalizeCheckpoint(long superstep, List<WorkerInfo> chosenWorkerInfoList) throws IOException, KeeperException, InterruptedException {
        Path finalizedCheckpointPath = new Path(this.getCheckpointBasePath(superstep) + ".finalized");
        try {
            this.getFs().delete(finalizedCheckpointPath, false);
        }
        catch (IOException e) {
            LOG.warn((Object)("finalizedValidCheckpointPrefixes: Removed old file " + finalizedCheckpointPath));
        }
        FSDataOutputStream finalizedOutputStream = this.getFs().create(finalizedCheckpointPath);
        String superstepFinishedNode = this.getSuperstepFinishedPath(this.getApplicationAttempt(), superstep - 1L);
        finalizedOutputStream.write(this.getZkExt().getData(superstepFinishedNode, false, null));
        finalizedOutputStream.writeInt(chosenWorkerInfoList.size());
        finalizedOutputStream.writeUTF(this.getCheckpointBasePath(superstep));
        for (WorkerInfo chosenWorkerInfo : chosenWorkerInfoList) {
            finalizedOutputStream.writeInt(chosenWorkerInfo.getTaskId());
        }
        this.globalCommHandler.write((DataOutput)finalizedOutputStream);
        this.aggregatorTranslation.write((DataOutput)finalizedOutputStream);
        this.masterCompute.write((DataOutput)finalizedOutputStream);
        finalizedOutputStream.close();
        this.lastCheckpointedSuperstep = superstep;
        GiraphStats.getInstance().getLastCheckpointedSuperstep().setValue(superstep);
    }

    private void assignPartitionOwners() {
        Collection<PartitionOwner> partitionOwners;
        if (this.getSuperstep() == -1L) {
            partitionOwners = this.masterGraphPartitioner.createInitialPartitionOwners(this.chosenWorkerInfoList, this.maxWorkers);
            if (partitionOwners.isEmpty()) {
                throw new IllegalStateException("assignAndExchangePartitions: No partition owners set");
            }
        } else if (this.getRestartedSuperstep() == this.getSuperstep()) {
            try {
                partitionOwners = this.prepareCheckpointRestart(this.getSuperstep());
            }
            catch (IOException e) {
                throw new IllegalStateException("assignPartitionOwners: IOException on preparing", e);
            }
            catch (KeeperException e) {
                throw new IllegalStateException("assignPartitionOwners: KeeperException on preparing", e);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("assignPartitionOwners: InteruptedException on preparing", e);
            }
            this.masterGraphPartitioner.setPartitionOwners(partitionOwners);
        } else {
            partitionOwners = this.masterGraphPartitioner.generateChangedPartitionOwners(this.allPartitionStatsList, this.chosenWorkerInfoList, this.maxWorkers, this.getSuperstep());
            PartitionUtils.analyzePartitionStats(partitionOwners, this.allPartitionStatsList);
        }
        this.checkPartitions(this.masterGraphPartitioner.getCurrentPartitionOwners());
        if (!partitionOwners.isEmpty()) {
            String vertexExchangePath = this.getPartitionExchangePath(this.getApplicationAttempt(), this.getSuperstep());
            try {
                this.getZkExt().createOnceExt(vertexExchangePath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
            }
            catch (KeeperException e) {
                throw new IllegalStateException("assignPartitionOwners: KeeperException creating " + vertexExchangePath);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("assignPartitionOwners: InterruptedException creating " + vertexExchangePath);
            }
        }
        AddressesAndPartitionsWritable addressesAndPartitions = new AddressesAndPartitionsWritable(this.masterInfo, this.chosenWorkerInfoList, partitionOwners);
        String addressesAndPartitionsPath = this.getAddressesAndPartitionsPath(this.getApplicationAttempt(), this.getSuperstep());
        WritableUtils.writeToZnode(this.getZkExt(), addressesAndPartitionsPath, -1, addressesAndPartitions);
    }

    private void checkPartitions(Collection<PartitionOwner> partitionOwners) {
        for (PartitionOwner partitionOwner : partitionOwners) {
            int partitionId = partitionOwner.getPartitionId();
            if (partitionId >= 0 && partitionId < partitionOwners.size()) continue;
            throw new IllegalStateException("checkPartitions: Invalid partition id " + partitionId + " - partition ids must be values from 0 to (numPartitions - 1)");
        }
    }

    private Collection<WorkerInfo> superstepChosenWorkerAlive(String chosenWorkerInfoHealthPath, List<WorkerInfo> chosenWorkerInfoList) throws KeeperException, InterruptedException {
        List<WorkerInfo> chosenWorkerInfoHealthyList = this.getWorkerInfosFromPath(chosenWorkerInfoHealthPath, false);
        HashSet<WorkerInfo> chosenWorkerInfoHealthySet = new HashSet<WorkerInfo>(chosenWorkerInfoHealthyList);
        ArrayList<WorkerInfo> deadWorkers = new ArrayList<WorkerInfo>();
        for (WorkerInfo chosenWorkerInfo : chosenWorkerInfoList) {
            if (chosenWorkerInfoHealthySet.contains(chosenWorkerInfo)) continue;
            deadWorkers.add(chosenWorkerInfo);
        }
        return deadWorkers;
    }

    @Override
    public void restartFromCheckpoint(long checkpoint) {
        this.zkDeleteNode(this.vertexInputSplitsPaths.getPath());
        this.zkDeleteNode(this.edgeInputSplitsPaths.getPath());
        this.setApplicationAttempt(this.getApplicationAttempt() + 1L);
        this.setCachedSuperstep(checkpoint);
        this.setRestartedSuperstep(checkpoint);
        this.setJobState(ApplicationState.START_SUPERSTEP, this.getApplicationAttempt(), checkpoint);
    }

    private void zkDeleteNode(String path) {
        try {
            this.getZkExt().deleteExt(path, -1, true);
        }
        catch (KeeperException.NoNodeException e) {
            LOG.info((Object)("zkDeleteNode: node has already been removed " + path));
        }
        catch (InterruptedException e) {
            throw new RuntimeException("zkDeleteNode: InterruptedException", e);
        }
        catch (KeeperException e) {
            throw new RuntimeException("zkDeleteNode: KeeperException", e);
        }
    }

    @Override
    public long getLastGoodCheckpoint() throws IOException {
        if (this.lastCheckpointedSuperstep == -1L) {
            try {
                this.lastCheckpointedSuperstep = this.getLastCheckpointedSuperstep();
            }
            catch (IOException e) {
                LOG.fatal((Object)"getLastGoodCheckpoint: No last good checkpoints can be found, killing the job.", (Throwable)e);
                this.failJob(e);
            }
        }
        return this.lastCheckpointedSuperstep;
    }

    /*
     * Exception decompiling
     */
    private boolean barrierOnWorkerList(String finishedWorkerPath, List<WorkerInfo> workerInfoList, BspEvent event, boolean ignoreDeath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void cleanUpOldSuperstep(long removeableSuperstep) throws InterruptedException {
        if (GiraphConstants.KEEP_ZOOKEEPER_DATA.isFalse(this.getConfiguration()) && removeableSuperstep >= 0L) {
            String oldSuperstepPath = this.getSuperstepPath(this.getApplicationAttempt()) + "/" + removeableSuperstep;
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("coordinateSuperstep: Cleaning up old Superstep " + oldSuperstepPath));
                }
                this.getZkExt().deleteExt(oldSuperstepPath, -1, true);
            }
            catch (KeeperException.NoNodeException e) {
                LOG.warn((Object)("coordinateBarrier: Already cleaned up " + oldSuperstepPath));
            }
            catch (KeeperException e) {
                throw new IllegalStateException("coordinateSuperstep: KeeperException on finalizing checkpoint", e);
            }
        }
    }

    private void coordinateInputSplits(InputSplitPaths inputSplitPaths, InputSplitEvents inputSplitEvents, String inputSplitsType) {
        String logPrefix = "coordinate" + inputSplitsType + "InputSplits";
        if (!this.barrierOnWorkerList(inputSplitPaths.getDonePath(), this.chosenWorkerInfoList, inputSplitEvents.getDoneStateChanged(), false)) {
            throw new IllegalStateException(logPrefix + ": Worker failed during " + "input split (currently not supported)");
        }
        try {
            this.getZkExt().createExt(inputSplitPaths.getAllDonePath(), null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, false);
        }
        catch (KeeperException.NodeExistsException e) {
            LOG.info((Object)("coordinateInputSplits: Node " + inputSplitPaths.getAllDonePath() + " already exists."));
        }
        catch (KeeperException e) {
            throw new IllegalStateException(logPrefix + ": KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(logPrefix + ": IllegalStateException", e);
        }
    }

    private void initializeAggregatorInputSuperstep() throws InterruptedException {
        this.globalCommHandler.prepareSuperstep();
        this.prepareMasterCompute(this.getSuperstep());
        try {
            this.masterCompute.initialize();
        }
        catch (InstantiationException e) {
            LOG.fatal((Object)"initializeAggregatorInputSuperstep: Failed in instantiation", (Throwable)e);
            throw new RuntimeException("initializeAggregatorInputSuperstep: Failed in instantiation", e);
        }
        catch (IllegalAccessException e) {
            LOG.fatal((Object)"initializeAggregatorInputSuperstep: Failed in access", (Throwable)e);
            throw new RuntimeException("initializeAggregatorInputSuperstep: Failed in access", e);
        }
        this.aggregatorTranslation.postMasterCompute();
        this.globalCommHandler.finishSuperstep();
        this.globalCommHandler.sendDataToOwners(this.masterClient);
    }

    private SuperstepClasses prepareMasterCompute(long superstep) {
        GraphState graphState = new GraphState(superstep, GiraphStats.getInstance().getVertices().getValue(), GiraphStats.getInstance().getEdges().getValue(), this.getContext());
        SuperstepClasses superstepClasses = new SuperstepClasses(this.getConfiguration());
        this.masterCompute.setGraphState(graphState);
        this.masterCompute.setSuperstepClasses(superstepClasses);
        return superstepClasses;
    }

    @Override
    public SuperstepState coordinateSuperstep() throws KeeperException, InterruptedException {
        String finishedWorkerPath;
        for (MasterObserver observer : this.observers) {
            observer.preSuperstep(this.getSuperstep());
            this.getContext().progress();
        }
        this.chosenWorkerInfoList = this.checkWorkers();
        if (this.chosenWorkerInfoList == null) {
            this.setJobStateFailed("coordinateSuperstep: Not enough healthy workers for superstep " + this.getSuperstep());
        } else {
            Collections.sort(this.chosenWorkerInfoList, new Comparator<WorkerInfo>(){

                @Override
                public int compare(WorkerInfo wi1, WorkerInfo wi2) {
                    return Integer.compare(wi1.getTaskId(), wi2.getTaskId());
                }
            });
            for (WorkerInfo workerInfo : this.chosenWorkerInfoList) {
                String workerInfoHealthyPath = this.getWorkerInfoHealthyPath(this.getApplicationAttempt(), this.getSuperstep()) + "/" + workerInfo.getHostnameId();
                if (this.getZkExt().exists(workerInfoHealthyPath, true) != null) continue;
                LOG.warn((Object)("coordinateSuperstep: Chosen worker " + workerInfoHealthyPath + " is no longer valid, failing superstep"));
            }
        }
        if (this.getSuperstep() >= 0L) {
            this.aggregatorTranslation.postMasterCompute();
            this.globalCommHandler.finishSuperstep();
        }
        this.masterClient.openConnections();
        GiraphStats.getInstance().getCurrentWorkers().setValue(this.chosenWorkerInfoList.size());
        this.assignPartitionOwners();
        if (this.checkpointStatus != CheckpointStatus.NONE) {
            String workerWroteCheckpointPath = this.getWorkerWroteCheckpointPath(this.getApplicationAttempt(), this.getSuperstep());
            if (!this.barrierOnWorkerList(workerWroteCheckpointPath, this.chosenWorkerInfoList, this.getWorkerWroteCheckpointEvent(), this.checkpointStatus == CheckpointStatus.CHECKPOINT_AND_HALT)) {
                return SuperstepState.WORKER_FAILURE;
            }
            try {
                this.finalizeCheckpoint(this.getSuperstep(), this.chosenWorkerInfoList);
            }
            catch (IOException e) {
                throw new IllegalStateException("coordinateSuperstep: IOException on finalizing checkpoint", e);
            }
            if (this.checkpointStatus == CheckpointStatus.CHECKPOINT_AND_HALT) {
                return SuperstepState.CHECKPOINT_AND_HALT;
            }
        }
        if (this.getSuperstep() >= 0L) {
            this.globalCommHandler.sendDataToOwners(this.masterClient);
        }
        if (this.getSuperstep() == -1L) {
            this.initializeAggregatorInputSuperstep();
            if (this.getConfiguration().hasMappingInputFormat()) {
                this.coordinateInputSplits(this.mappingInputSplitsPaths, this.mappingInputSplitsEvents, "Mapping");
            }
            if (this.getConfiguration().hasVertexInputFormat()) {
                this.coordinateInputSplits(this.vertexInputSplitsPaths, this.vertexInputSplitsEvents, "Vertex");
            }
            if (this.getConfiguration().hasEdgeInputFormat()) {
                this.coordinateInputSplits(this.edgeInputSplitsPaths, this.edgeInputSplitsEvents, "Edge");
            }
        }
        if (!this.barrierOnWorkerList(finishedWorkerPath = this.getWorkerFinishedPath(this.getApplicationAttempt(), this.getSuperstep()), this.chosenWorkerInfoList, this.getSuperstepStateChangedEvent(), false)) {
            return SuperstepState.WORKER_FAILURE;
        }
        this.globalCommHandler.prepareSuperstep();
        this.aggregatorTranslation.prepareSuperstep();
        SuperstepClasses superstepClasses = this.prepareMasterCompute(this.getSuperstep() + 1L);
        this.doMasterCompute();
        GlobalStats globalStats = this.aggregateWorkerStats(this.getSuperstep());
        if (this.masterCompute.isHalted() || globalStats.getFinishedVertexCount() == globalStats.getVertexCount() && globalStats.getMessageCount() == 0L) {
            globalStats.setHaltComputation(true);
        } else if (this.getZkExt().exists(this.haltComputationPath, false) != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Halting computation because halt zookeeper node was created");
            }
            globalStats.setHaltComputation(true);
        }
        if (this.maxNumberOfSupersteps != GiraphConstants.MAX_NUMBER_OF_SUPERSTEPS.getDefaultValue() && this.getSuperstep() == (long)(this.maxNumberOfSupersteps - 1)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("coordinateSuperstep: Finished " + this.maxNumberOfSupersteps + " supersteps (max specified by the user), halting"));
            }
            globalStats.setHaltComputation(true);
        }
        if (!globalStats.getHaltComputation()) {
            superstepClasses.verifyTypesMatch(this.getConfiguration(), this.getSuperstep() != 0L);
        }
        this.getConfiguration().updateSuperstepClasses(superstepClasses);
        this.checkpointStatus = this.getCheckpointStatus(this.getSuperstep() + 1L);
        globalStats.setCheckpointStatus(this.checkpointStatus);
        String superstepFinishedNode = this.getSuperstepFinishedPath(this.getApplicationAttempt(), this.getSuperstep());
        WritableUtils.writeToZnode(this.getZkExt(), superstepFinishedNode, -1, globalStats, superstepClasses);
        this.updateCounters(globalStats);
        this.cleanUpOldSuperstep(this.getSuperstep() - 1L);
        this.incrCachedSuperstep();
        if (this.getSuperstep() > 0L) {
            GiraphStats.getInstance().getSuperstepCounter().increment();
        }
        SuperstepState superstepState = globalStats.getHaltComputation() ? SuperstepState.ALL_SUPERSTEPS_DONE : SuperstepState.THIS_SUPERSTEP_DONE;
        this.globalCommHandler.writeAggregators(this.getSuperstep(), superstepState);
        return superstepState;
    }

    private CheckpointStatus getCheckpointStatus(long superstep) {
        try {
            if (this.getZkExt().exists(this.basePath + "/_checkpointAndStop", false) != null) {
                return CheckpointStatus.CHECKPOINT_AND_HALT;
            }
        }
        catch (KeeperException e) {
            throw new IllegalStateException("cleanupZooKeeper: Got KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("cleanupZooKeeper: Got IllegalStateException", e);
        }
        if (this.checkpointFrequency == 0) {
            return CheckpointStatus.NONE;
        }
        long firstCheckpoint = 0L + (long)this.checkpointFrequency;
        if (this.getRestartedSuperstep() != Long.MIN_VALUE) {
            firstCheckpoint = this.getRestartedSuperstep() + (long)this.checkpointFrequency;
        }
        if (superstep < firstCheckpoint) {
            return CheckpointStatus.NONE;
        }
        if ((superstep - firstCheckpoint) % (long)this.checkpointFrequency == 0L) {
            return CheckpointStatus.CHECKPOINT;
        }
        return CheckpointStatus.NONE;
    }

    private void doMasterCompute() {
        GiraphTimerContext timerContext = this.masterComputeTimer.time();
        this.masterCompute.compute();
        timerContext.stop();
    }

    private void cleanUpZooKeeper() {
        try {
            this.getZkExt().createExt(this.cleanedUpPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
        }
        catch (KeeperException.NodeExistsException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("cleanUpZooKeeper: Node " + this.cleanedUpPath + " already exists, no need to create."));
            }
        }
        catch (KeeperException e) {
            throw new IllegalStateException("cleanupZooKeeper: Got KeeperException", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("cleanupZooKeeper: Got IllegalStateException", e);
        }
        int maxTasks = BspInputFormat.getMaxTasks(this.getConfiguration());
        if (this.getGraphTaskManager().getGraphFunctions() == GraphFunctions.ALL || this.getGraphTaskManager().getGraphFunctions() == GraphFunctions.ALL_EXCEPT_ZOOKEEPER) {
            maxTasks *= 2;
        }
        List<String> cleanedUpChildrenList = null;
        while (true) {
            try {
                cleanedUpChildrenList = this.getZkExt().getChildrenExt(this.cleanedUpPath, true, false, true);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("cleanUpZooKeeper: Got " + cleanedUpChildrenList.size() + " of " + maxTasks + " desired children from " + this.cleanedUpPath));
                }
                if (cleanedUpChildrenList.size() == maxTasks) break;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("cleanedUpZooKeeper: Waiting for the children of " + this.cleanedUpPath + " to change since only got " + cleanedUpChildrenList.size() + " nodes."));
                }
            }
            catch (KeeperException e) {
                LOG.error((Object)"cleanUpZooKeeper: Got KeeperException, but will continue", (Throwable)e);
                return;
            }
            catch (InterruptedException e) {
                LOG.error((Object)"cleanUpZooKeeper: Got InterruptedException, but will continue", (Throwable)e);
                return;
            }
            this.getCleanedUpChildrenChangedEvent().waitForever();
            this.getCleanedUpChildrenChangedEvent().reset();
        }
        try {
            if (this.getConfiguration().isZookeeperExternal() && GiraphConstants.KEEP_ZOOKEEPER_DATA.isFalse(this.getConfiguration())) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("cleanupZooKeeper: Removing the following path and all children - " + this.basePath + " from ZooKeeper list " + this.getConfiguration().getZookeeperList()));
                }
                this.getZkExt().deleteExt(this.basePath, -1, true);
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)("cleanupZooKeeper: Failed to do cleanup of " + this.basePath + " due to KeeperException"), (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error((Object)("cleanupZooKeeper: Failed to do cleanup of " + this.basePath + " due to InterruptedException"), (Throwable)e);
        }
    }

    @Override
    public void postApplication() {
        for (MasterObserver observer : this.observers) {
            observer.postApplication();
            this.getContext().progress();
        }
    }

    @Override
    public void postSuperstep() {
        for (MasterObserver observer : this.observers) {
            observer.postSuperstep(this.getSuperstep());
            this.getContext().progress();
        }
    }

    @Override
    public void failureCleanup(Exception e) {
        for (MasterObserver observer : this.observers) {
            try {
                observer.applicationFailed(e);
            }
            catch (RuntimeException re) {
                LOG.error((Object)(re.getClass().getName() + " from observer " + observer.getClass().getName()), (Throwable)re);
            }
            this.getContext().progress();
        }
    }

    @Override
    public void cleanup(SuperstepState superstepState) throws IOException {
        ImmutableClassesGiraphConfiguration conf = this.getConfiguration();
        String masterCleanedUpPath = this.cleanedUpPath + "/" + this.getTaskPartition() + "_master";
        try {
            String finalFinishedPath = this.getZkExt().createExt(masterCleanedUpPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("cleanup: Notifying master its okay to cleanup with " + finalFinishedPath));
            }
        }
        catch (KeeperException.NodeExistsException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("cleanup: Couldn't create finished node '" + masterCleanedUpPath));
            }
        }
        catch (KeeperException e) {
            LOG.error((Object)"cleanup: Got KeeperException, continuing", (Throwable)e);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"cleanup: Got InterruptedException, continuing", (Throwable)e);
        }
        if (this.isMaster) {
            this.getGraphTaskManager().setIsMaster(true);
            this.cleanUpZooKeeper();
            if (superstepState == SuperstepState.ALL_SUPERSTEPS_DONE && GiraphConstants.CLEANUP_CHECKPOINTS_AFTER_SUCCESS.get(conf)) {
                boolean success = this.getFs().delete(new Path(this.checkpointBasePath), true);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("cleanup: Removed HDFS checkpoint directory (" + this.checkpointBasePath + ") with return = " + success + " since the job " + this.getContext().getJobName() + " succeeded "));
                }
            }
            if (superstepState == SuperstepState.CHECKPOINT_AND_HALT) {
                this.getFs().create(CheckpointingUtils.getCheckpointMarkPath(conf, this.getJobId()), true);
                this.failJob(new Exception("Checkpoint and halt requested. Killing this job."));
            }
            this.globalCommHandler.close();
            this.masterClient.closeConnections();
            this.masterServer.close();
        }
        try {
            this.getZkExt().close();
        }
        catch (InterruptedException e) {
            LOG.error((Object)"cleanup: Zookeeper failed to close", (Throwable)e);
        }
    }

    public final BspEvent getWorkerWroteCheckpointEvent() {
        return this.workerWroteCheckpoint;
    }

    public final BspEvent getSuperstepStateChangedEvent() {
        return this.superstepStateChanged;
    }

    private void checkHealthyWorkerFailure(String failedWorkerPath) {
        if (BspServiceMaster.getSuperstepFromPath(failedWorkerPath) < this.getSuperstep()) {
            return;
        }
        Collection<PartitionOwner> partitionOwners = this.masterGraphPartitioner.getCurrentPartitionOwners();
        String hostnameId = BspServiceMaster.getHealthyHostnameIdFromPath(failedWorkerPath);
        for (PartitionOwner partitionOwner : partitionOwners) {
            WorkerInfo workerInfo = partitionOwner.getWorkerInfo();
            WorkerInfo previousWorkerInfo = partitionOwner.getPreviousWorkerInfo();
            if (!workerInfo.getHostnameId().equals(hostnameId) && (previousWorkerInfo == null || !previousWorkerInfo.getHostnameId().equals(hostnameId))) continue;
            LOG.warn((Object)("checkHealthyWorkerFailure: at least one healthy worker went down for superstep " + this.getSuperstep() + " - " + hostnameId + ", will try to restart from " + "checkpointed superstep " + this.lastCheckpointedSuperstep));
            this.superstepStateChanged.signal();
        }
    }

    @Override
    public boolean processEvent(WatchedEvent event) {
        boolean foundEvent = false;
        if (event.getPath().contains("/_workerHealthyDir") && event.getType() == Watcher.Event.EventType.NodeDeleted) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("processEvent: Healthy worker died (node deleted) in " + event.getPath()));
            }
            this.checkHealthyWorkerFailure(event.getPath());
            this.superstepStateChanged.signal();
            foundEvent = true;
        } else if (event.getPath().contains("/_workerFinishedDir") && event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"processEvent: Worker finished (node change) event - superstepStateChanged signaled");
            }
            this.superstepStateChanged.signal();
            foundEvent = true;
        } else if (event.getPath().contains("/_workerWroteCheckpointDir") && event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"processEvent: Worker wrote checkpoint (node change) event - workerWroteCheckpoint signaled");
            }
            this.workerWroteCheckpoint.signal();
            foundEvent = true;
        }
        return foundEvent;
    }

    private void updateCounters(GlobalStats globalStats) {
        GiraphStats gs = GiraphStats.getInstance();
        gs.getVertices().setValue(globalStats.getVertexCount());
        gs.getFinishedVertexes().setValue(globalStats.getFinishedVertexCount());
        gs.getEdges().setValue(globalStats.getEdgeCount());
        gs.getSentMessages().setValue(globalStats.getMessageCount());
        gs.getSentMessageBytes().setValue(globalStats.getMessageBytesCount());
        gs.getAggregateSentMessages().increment(globalStats.getMessageCount());
        gs.getAggregateSentMessageBytes().increment(globalStats.getMessageBytesCount());
    }

    private class WriteInputSplit
    implements Callable<Void> {
        private final GiraphInputFormat inputFormat;
        private final InputSplit inputSplit;
        private final String inputSplitsPath;
        private final int index;
        private final boolean writeLocations;

        public WriteInputSplit(GiraphInputFormat inputFormat, InputSplit inputSplit, String inputSplitsPath, int index, boolean writeLocations) {
            this.inputFormat = inputFormat;
            this.inputSplit = inputSplit;
            this.inputSplitsPath = inputSplitsPath;
            this.index = index;
            this.writeLocations = writeLocations;
        }

        @Override
        public Void call() {
            String inputSplitPath = null;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);
                if (this.writeLocations) {
                    String[] splitLocations = this.inputSplit.getLocations();
                    StringBuilder locations = null;
                    if (splitLocations != null) {
                        int splitListLength = Math.min(splitLocations.length, 5);
                        locations = new StringBuilder();
                        for (String location : splitLocations) {
                            locations.append(location).append(--splitListLength > 0 ? "\t" : "");
                        }
                    }
                    Text.writeString((DataOutput)outputStream, (String)(locations == null ? "" : locations.toString()));
                }
                this.inputFormat.writeInputSplit(this.inputSplit, outputStream);
                inputSplitPath = this.inputSplitsPath + "/" + this.index;
                BspServiceMaster.this.getZkExt().createExt(inputSplitPath, byteArrayOutputStream.toByteArray(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("call: Created input split with index " + this.index + " serialized as " + byteArrayOutputStream.toString(Charset.defaultCharset().name())));
                }
            }
            catch (KeeperException.NodeExistsException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("call: Node " + inputSplitPath + " already exists."));
                }
            }
            catch (KeeperException e) {
                throw new IllegalStateException("call: KeeperException", e);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("call: IllegalStateException", e);
            }
            catch (IOException e) {
                throw new IllegalStateException("call: IOException", e);
            }
            return null;
        }
    }
}

