/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.master;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.giraph.aggregators.Aggregator;
import org.apache.giraph.comm.aggregators.AggregatorUtils;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.master.AggregatorBroadcast;
import org.apache.giraph.master.AggregatorReduceOperation;
import org.apache.giraph.master.MasterAggregatorUsage;
import org.apache.giraph.master.MasterGlobalCommUsage;
import org.apache.giraph.utils.MasterLoggingAggregator;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

public class AggregatorToGlobalCommTranslation
implements MasterAggregatorUsage,
Writable {
    private static final Logger LOG = Logger.getLogger(AggregatorToGlobalCommTranslation.class);
    private final MasterGlobalCommUsage globalComm;
    private final HashMap<String, AggregatorWrapper<Writable>> registeredAggregators = new HashMap();
    private final HashMap<String, Writable> initAggregatorValues = new HashMap();
    private final ImmutableClassesGiraphConfiguration<?, ?, ?> conf;

    public AggregatorToGlobalCommTranslation(ImmutableClassesGiraphConfiguration<?, ?, ?> conf, MasterGlobalCommUsage globalComm) {
        this.conf = conf;
        this.globalComm = globalComm;
        MasterLoggingAggregator.registerAggregator(this, conf);
    }

    @Override
    public <A extends Writable> A getAggregatedValue(String name) {
        AggregatorWrapper<Writable> agg = this.registeredAggregators.get(name);
        if (agg == null) {
            LOG.warn((Object)("getAggregatedValue: " + AggregatorUtils.getUnregisteredAggregatorMessage(name, this.registeredAggregators.size() != 0, this.conf)));
            return null;
        }
        Object value = this.globalComm.getReduced(name);
        if (value == null) {
            value = this.initAggregatorValues.get(name);
        }
        if (value == null) {
            value = agg.getReduceOp().createInitialValue();
            this.initAggregatorValues.put(name, (Writable)value);
        }
        Preconditions.checkState((value != null ? 1 : 0) != 0);
        return (A)value;
    }

    @Override
    public <A extends Writable> void setAggregatedValue(String name, A value) {
        AggregatorWrapper<Writable> aggregator = this.registeredAggregators.get(name);
        if (aggregator == null) {
            throw new IllegalArgumentException("setAggregatedValue: " + AggregatorUtils.getUnregisteredAggregatorMessage(name, this.registeredAggregators.size() != 0, this.conf));
        }
        aggregator.setCurrentValue(value);
    }

    public void postMasterCompute() {
        for (Map.Entry<String, AggregatorWrapper<Writable>> entry : this.registeredAggregators.entrySet()) {
            Object value = entry.getValue().getCurrentValue();
            if (value == null) {
                value = this.globalComm.getReduced(entry.getKey());
            }
            Preconditions.checkState((value != null ? 1 : 0) != 0);
            this.globalComm.broadcast(entry.getKey(), new AggregatorBroadcast<Writable>(entry.getValue().getReduceOp().getAggregatorClass(), (Writable)value));
            AggregatorReduceOperation<Writable> cleanReduceOp = entry.getValue().createReduceOp();
            if (entry.getValue().isPersistent()) {
                this.globalComm.registerReduce(entry.getKey(), cleanReduceOp, value);
            } else {
                this.globalComm.registerReduce(entry.getKey(), cleanReduceOp);
            }
            entry.getValue().setCurrentValue(null);
        }
        this.initAggregatorValues.clear();
    }

    public void prepareSuperstep() {
        MasterLoggingAggregator.logAggregatedValue(this, this.conf);
    }

    @Override
    public <A extends Writable> boolean registerAggregator(String name, Class<? extends Aggregator<A>> aggregatorClass) throws InstantiationException, IllegalAccessException {
        return this.registerAggregator(name, aggregatorClass, false) != null;
    }

    @Override
    public <A extends Writable> boolean registerPersistentAggregator(String name, Class<? extends Aggregator<A>> aggregatorClass) throws InstantiationException, IllegalAccessException {
        return this.registerAggregator(name, aggregatorClass, true) != null;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.registeredAggregators.size());
        for (Map.Entry<String, AggregatorWrapper<Writable>> entry : this.registeredAggregators.entrySet()) {
            out.writeUTF(entry.getKey());
            entry.getValue().write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.registeredAggregators.clear();
        int numAggregators = in.readInt();
        for (int i = 0; i < numAggregators; ++i) {
            String name = in.readUTF();
            AggregatorWrapper agg = new AggregatorWrapper();
            agg.readFields(in);
            this.registeredAggregators.put(name, agg);
        }
        this.initAggregatorValues.clear();
    }

    private <A extends Writable> AggregatorWrapper<A> registerAggregator(String name, Class<? extends Aggregator<A>> aggregatorClass, boolean persistent) throws InstantiationException, IllegalAccessException {
        AggregatorWrapper<Object> aggregatorWrapper = this.registeredAggregators.get(name);
        if (aggregatorWrapper == null) {
            aggregatorWrapper = new AggregatorWrapper(aggregatorClass, persistent);
            aggregatorWrapper.setCurrentValue(aggregatorWrapper.getReduceOp().createInitialValue());
            this.registeredAggregators.put(name, aggregatorWrapper);
        }
        return aggregatorWrapper;
    }

    private class AggregatorWrapper<A extends Writable>
    implements Writable {
        private boolean persistent;
        private AggregatorReduceOperation<A> reduceOp;
        private A currentValue;

        public AggregatorWrapper() {
        }

        public AggregatorWrapper(Class<? extends Aggregator<A>> aggregatorClass, boolean persistent) {
            this.persistent = persistent;
            this.reduceOp = new AggregatorReduceOperation(aggregatorClass, AggregatorToGlobalCommTranslation.this.conf);
        }

        public AggregatorReduceOperation<A> getReduceOp() {
            return this.reduceOp;
        }

        public AggregatorReduceOperation<A> createReduceOp() {
            return this.reduceOp.createCopy();
        }

        public A getCurrentValue() {
            return this.currentValue;
        }

        public void setCurrentValue(A currentValue) {
            this.currentValue = currentValue;
        }

        public boolean isPersistent() {
            return this.persistent;
        }

        public void write(DataOutput out) throws IOException {
            out.writeBoolean(this.persistent);
            this.reduceOp.write(out);
            Preconditions.checkState((this.currentValue == null ? 1 : 0) != 0, (Object)"AggregatorWrapper shouldn't have value at the end of the superstep");
        }

        public void readFields(DataInput in) throws IOException {
            this.persistent = in.readBoolean();
            this.reduceOp = new AggregatorReduceOperation();
            this.reduceOp.readFields(in);
            this.currentValue = null;
        }
    }
}

