/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.master;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.aggregators.Aggregator;
import org.apache.giraph.conf.GiraphConfigurationSettable;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.reducers.OnSameReduceOperation;
import org.apache.giraph.utils.ReflectionUtils;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;

public class AggregatorReduceOperation<A extends Writable>
extends OnSameReduceOperation<A>
implements GiraphConfigurationSettable {
    private Class<? extends Aggregator<A>> aggregatorClass;
    private Aggregator<A> aggregator;
    private ImmutableClassesGiraphConfiguration<?, ?, ?> conf;

    public AggregatorReduceOperation() {
    }

    public AggregatorReduceOperation(Class<? extends Aggregator<A>> aggregatorClass, ImmutableClassesGiraphConfiguration<?, ?, ?> conf) {
        this.aggregatorClass = aggregatorClass;
        this.conf = conf;
        this.initAggregator();
    }

    private void initAggregator() {
        this.aggregator = ReflectionUtils.newInstance(this.aggregatorClass, this.conf);
        this.aggregator.setAggregatedValue(null);
    }

    @Override
    public A createInitialValue() {
        A agg = this.aggregator.createInitialValue();
        if (agg == null) {
            throw new IllegalStateException("Aggregators initial value must not be null, but is for " + this.aggregator);
        }
        return agg;
    }

    public AggregatorReduceOperation<A> createCopy() {
        return new AggregatorReduceOperation<A>(this.aggregatorClass, this.conf);
    }

    public Class<? extends Aggregator<A>> getAggregatorClass() {
        return this.aggregatorClass;
    }

    @Override
    public synchronized A reduceSingle(A curValue, A valueToReduce) {
        this.aggregator.setAggregatedValue(curValue);
        this.aggregator.aggregate(valueToReduce);
        A aggregated = this.aggregator.getAggregatedValue();
        this.aggregator.setAggregatedValue(null);
        return aggregated;
    }

    public void setConf(ImmutableClassesGiraphConfiguration conf) {
        this.conf = conf;
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeClass(this.aggregatorClass, out);
    }

    public void readFields(DataInput in) throws IOException {
        this.aggregatorClass = WritableUtils.readClass(in);
        this.initAggregator();
    }
}

