/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.master;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.aggregators.Aggregator;
import org.apache.giraph.conf.DefaultImmutableClassesGiraphConfigurable;
import org.apache.giraph.utils.ReflectionUtils;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;

public class AggregatorBroadcast<A extends Writable>
extends DefaultImmutableClassesGiraphConfigurable
implements Writable {
    private Class<? extends Aggregator<A>> aggregatorClass;
    private A value;

    public AggregatorBroadcast() {
    }

    public AggregatorBroadcast(Class<? extends Aggregator<A>> aggregatorClass, A value) {
        this.aggregatorClass = aggregatorClass;
        this.value = value;
    }

    public A getValue() {
        return this.value;
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeClass(this.aggregatorClass, out);
        this.value.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.aggregatorClass = WritableUtils.readClass(in);
        this.value = ReflectionUtils.newInstance(this.aggregatorClass, this.getConf()).createInitialValue();
        this.value.readFields(in);
    }
}

