/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.mapping.translate;

import org.apache.giraph.conf.DefaultImmutableClassesGiraphConfigurable;
import org.apache.giraph.mapping.translate.TranslateEdge;
import org.apache.giraph.worker.BspServiceWorker;
import org.apache.giraph.worker.LocalData;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;

public class LongByteTranslateEdge<E extends Writable>
extends DefaultImmutableClassesGiraphConfigurable
implements TranslateEdge<LongWritable, E> {
    private LocalData<LongWritable, ? extends Writable, E, ByteWritable> localData;

    @Override
    public void initialize(BspServiceWorker<LongWritable, ? extends Writable, E> service) {
        this.localData = service.getLocalData();
    }

    @Override
    public LongWritable translateId(LongWritable targetId) {
        LongWritable translatedId = new LongWritable();
        translatedId.set(targetId.get());
        this.localData.getMappingStoreOps().embedTargetInfo(translatedId);
        return translatedId;
    }

    @Override
    public E cloneValue(E edgeValue) {
        throw new UnsupportedOperationException();
    }

    public static class DoubleEdgeValue
    extends LongByteTranslateEdge<DoubleWritable> {
        @Override
        public DoubleWritable cloneValue(DoubleWritable edgeValue) {
            return new DoubleWritable(edgeValue.get());
        }
    }

    public static class FloatEdgeValue
    extends LongByteTranslateEdge<FloatWritable> {
        @Override
        public FloatWritable cloneValue(FloatWritable edgeValue) {
            return new FloatWritable(edgeValue.get());
        }
    }

    public static class LongEdgeValue
    extends LongByteTranslateEdge<LongWritable> {
        @Override
        public LongWritable cloneValue(LongWritable edgeValue) {
            return new LongWritable(edgeValue.get());
        }
    }

    public static class IntEdgeValue
    extends LongByteTranslateEdge<IntWritable> {
        @Override
        public IntWritable cloneValue(IntWritable edgeValue) {
            return new IntWritable(edgeValue.get());
        }
    }

    public static class NoEdgeValue
    extends LongByteTranslateEdge<NullWritable> {
        @Override
        public NullWritable cloneValue(NullWritable edgeValue) {
            return NullWritable.get();
        }
    }
}

