/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.mapping;

import com.google.common.collect.MapMaker;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.giraph.conf.DefaultImmutableClassesGiraphConfigurable;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.mapping.MappingStore;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

@ThreadSafe
public class LongByteMappingStore
extends DefaultImmutableClassesGiraphConfigurable<LongWritable, Writable, Writable>
implements MappingStore<LongWritable, ByteWritable> {
    private static final Logger LOG = Logger.getLogger(LongByteMappingStore.class);
    private final AtomicLong numEntries = new AtomicLong(0L);
    private ConcurrentMap<Long, byte[]> concurrentIdToBytes;
    private Long2ObjectOpenHashMap<byte[]> idToBytes;
    private int lower;
    private int upper;
    private int lowerBitMask;
    private int lowerOrder;

    @Override
    public void initialize() {
        this.upper = GiraphConstants.LB_MAPPINGSTORE_UPPER.get(this.getConf());
        this.lower = GiraphConstants.LB_MAPPINGSTORE_LOWER.get(this.getConf());
        if ((this.lower & this.lower - 1) != 0) {
            throw new IllegalStateException("lower not a power of two");
        }
        this.lowerBitMask = this.lower - 1;
        this.lowerOrder = Integer.numberOfTrailingZeros(this.lower);
        this.concurrentIdToBytes = new MapMaker().initialCapacity(this.upper).concurrencyLevel(this.getConf().getNumInputSplitsThreads()).makeMap();
        this.idToBytes = new Long2ObjectOpenHashMap(this.upper);
    }

    public byte getByteTarget(LongWritable vertexId) {
        long key = vertexId.get() >>> this.lowerOrder;
        int suffix = (int)(vertexId.get() & (long)this.lowerBitMask);
        if (!this.idToBytes.containsKey(key)) {
            return -1;
        }
        return ((byte[])this.idToBytes.get(key))[suffix];
    }

    @Override
    public void addEntry(LongWritable vertexId, ByteWritable target) {
        long key = vertexId.get() >>> this.lowerOrder;
        byte[] bytes = (byte[])this.concurrentIdToBytes.get(key);
        if (bytes == null) {
            byte[] newBytes = new byte[this.lower];
            Arrays.fill(newBytes, (byte)-1);
            bytes = this.concurrentIdToBytes.putIfAbsent(key, newBytes);
            if (bytes == null) {
                bytes = newBytes;
            }
        }
        bytes[(int)(vertexId.get() & (long)this.lowerBitMask)] = target.get();
        this.numEntries.getAndIncrement();
    }

    @Override
    public ByteWritable getTarget(LongWritable vertexId, ByteWritable target) {
        Byte bval = this.getByteTarget(vertexId);
        if (bval == -1) {
            return null;
        }
        target.set(bval.byteValue());
        return target;
    }

    @Override
    public void postFilling() {
        for (Long id : this.concurrentIdToBytes.keySet()) {
            this.idToBytes.put(id, this.concurrentIdToBytes.get(id));
        }
        this.concurrentIdToBytes.clear();
        this.concurrentIdToBytes = null;
    }

    @Override
    public long getStats() {
        return this.numEntries.longValue();
    }
}

