/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.mapping;

import org.apache.giraph.mapping.AbstractLongByteOps;
import org.apache.hadoop.io.LongWritable;

public class DefaultEmbeddedLongByteOps
extends AbstractLongByteOps {
    private static final long MASK = -36028797018963968L;
    private static final long IMASK = 0x7FFFFFFFFFFFFFL;

    @Override
    public boolean hasEmbedding() {
        return true;
    }

    @Override
    public void embedTargetInfo(LongWritable id) {
        if ((id.get() & 0xFF80000000000000L) != 0L) {
            throw new IllegalStateException("Expected first 9 bits of long  to be empty");
        }
        byte target = this.mappingStore.getByteTarget(id);
        long maskValue = (1L + (long)target & 0xFFL) << 55;
        id.set(id.get() | maskValue);
    }

    @Override
    public void removeTargetInfo(LongWritable id) {
        id.set(id.get() & 0x7FFFFFFFFFFFFFL);
    }

    @Override
    public int getPartition(LongWritable id, int partitionCount, int workerCount) {
        byte target = (byte)((id.get() >>> 55 & 0xFFL) - 1L);
        return this.computePartition(id, partitionCount, workerCount, target);
    }
}

