/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.mapping;

import org.apache.giraph.mapping.LongByteMappingStore;
import org.apache.giraph.mapping.MappingStore;
import org.apache.giraph.mapping.MappingStoreOps;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.LongWritable;

public abstract class AbstractLongByteOps
implements MappingStoreOps<LongWritable, ByteWritable> {
    protected LongByteMappingStore mappingStore;

    @Override
    public void initialize(MappingStore<LongWritable, ByteWritable> mappingStore) {
        this.mappingStore = (LongByteMappingStore)mappingStore;
    }

    protected int computePartition(LongWritable id, int partitionCount, int workerCount, byte target) {
        int numRows = partitionCount / workerCount;
        int n = numRows = numRows * workerCount == partitionCount ? numRows : numRows + 1;
        if (target == -1) {
            return Math.abs(id.hashCode() % partitionCount);
        }
        int targetWorker = target & 0xFF;
        return numRows * targetWorker + Math.abs(id.hashCode() % numRows);
    }
}

