/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.jython.wrappers;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.jython.wrappers.JythonWrapperBase;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.log4j.Logger;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.modules.cPickle;

public class JythonWritableWrapper
extends JythonWrapperBase
implements WritableComparable {
    private static final Logger LOG = Logger.getLogger(JythonWritableWrapper.class);

    public JythonWritableWrapper(PyObject pyObject) {
        super(pyObject);
    }

    public void readFields(DataInput in) throws IOException {
        Object object;
        String str = WritableUtils.readString((DataInput)in);
        PyString pyString = new PyString(str);
        try {
            object = cPickle.loads((PyObject)pyString);
        }
        catch (PyException e) {
            LOG.fatal((Object)("Could not deserialize Jython value from string " + str));
            throw e;
        }
        Preconditions.checkArgument((boolean)(object instanceof PyObject));
        this.setPyObject((PyObject)object);
    }

    public void write(DataOutput out) throws IOException {
        PyString pyString;
        try {
            pyString = cPickle.dumps((PyObject)this.getPyObject());
        }
        catch (PyException e) {
            LOG.fatal((Object)("Could not serialize wrapped Jython value: " + this.getPyObject().__str__()));
            throw e;
        }
        WritableUtils.writeString((DataOutput)out, (String)pyString.getString());
    }

    public int compareTo(Object other) {
        int result = -1;
        if (other instanceof PyObject) {
            PyObject pyOther = (PyObject)other;
            result = this.getPyObject().__cmp__(pyOther);
        } else if (JythonWritableWrapper.class.equals(other.getClass())) {
            JythonWritableWrapper wrapperOther = (JythonWritableWrapper)((Object)other);
            result = this.getPyObject().__cmp__(wrapperOther.getPyObject());
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof JythonWritableWrapper) {
            return this.compareTo(obj) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getPyObject().__hash__().asInt();
    }
}

