/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.jython.factories;

import org.apache.giraph.conf.ClassConfOption;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.conf.StrConfOption;
import org.apache.giraph.factories.ValueFactory;
import org.apache.giraph.graph.GraphType;
import org.apache.giraph.jython.JythonOptions;
import org.apache.giraph.jython.JythonUtils;
import org.apache.giraph.jython.wrappers.JythonWritableWrapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;
import org.python.core.PyObject;

public abstract class JythonFactoryBase<W extends Writable>
implements ValueFactory<W> {
    private static final Logger LOG = Logger.getLogger(JythonFactoryBase.class);
    private String jythonClassName;
    private boolean useWrapper;

    public abstract JythonOptions.JythonGraphTypeOptions getOptions();

    public GraphType getGraphType() {
        return this.getOptions().getGraphType();
    }

    public StrConfOption jythonClassNameOption() {
        return this.getOptions().getJythonClassNameOption();
    }

    public Class<? extends Writable> writableValueClass() {
        return this.getGraphType().interfaceClass();
    }

    @Override
    public void initialize(ImmutableClassesGiraphConfiguration conf) {
        this.jythonClassName = this.jythonClassNameOption().get(conf);
        this.useWrapper = conf.getValueNeedsWrappers().get(this.getGraphType());
    }

    public Writable newJythonClassInstance() {
        if (this.useWrapper) {
            PyObject jythonObj = JythonUtils.newInstance(this.jythonClassName);
            JythonWritableWrapper wrapper = new JythonWritableWrapper(jythonObj);
            return wrapper;
        }
        return JythonUtils.newInstance(this.jythonClassName, this.writableValueClass());
    }

    @Override
    public Class<W> getValueClass() {
        if (this.useWrapper) {
            return JythonWritableWrapper.class;
        }
        return this.writableValueClass();
    }

    public void useThisFactory(Configuration conf, String jythonClassName) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("useThisFactory: Setting up Jython factory for " + (Object)((Object)this.getGraphType()) + " reading " + " using Jython type " + jythonClassName));
        }
        ClassConfOption factoryOption = this.getGraphType().factoryClassOption();
        factoryOption.set(conf, this.getClass());
        this.jythonClassNameOption().set(conf, jythonClassName);
    }
}

